# GMM (C) 2018-2019 Stephane Charette <stephanecharette@gmail.com>
# $Id: CM_dependencies.cmake 2718 2019-02-07 07:08:42Z stephane $


SET ( OpenGL_GL_PREFERENCE "GLVND" ) # choose between "LEGACY" and "GLVND"

IF ( UNIX )
	SET ( PostgreSQL_ADDITIONAL_VERSIONS 9.5 )
	SET ( PostgreSQL_TYPE_INCLUDE_DIR ${PostgreSQL_INCLUDE_DIR})
ENDIF ()

IF ( WIN32 )
	SET ( GUI_TYPE WIN32 )
	SET ( PostgreSQL_ROOT_DIRECTORIES "C:/Program Files/PostgreSQL" )
	SET ( PostgreSQL_ADDITIONAL_VERSIONS "9.5" "9.4" "9.3" "9.2" )
	SET ( DOXYGEN_DOT_EXECUTABLE "C:/Program Files (x86)/Graphviz2.34/bin/dot.exe" )
	LINK_DIRECTORIES 	( "C:/src/libpqxx-4.0.1/lib" )
	LINK_DIRECTORIES	( "C:/Program Files/Loxahatchee/lib" )
	INCLUDE_DIRECTORIES	( BEFORE "C:/src/libpqxx-4.0.1/include" )
	INCLUDE_DIRECTORIES	( BEFORE "C:/Program Files/Loxahatchee/include" )
	INCLUDE_DIRECTORIES ( BEFORE "C:/Program Files/libpqxx/libpqxx-4.0.1/include" )
	INCLUDE_DIRECTORIES ( BEFORE "C:/Include" )
ENDIF ()

FIND_PACKAGE ( PostgreSQL	REQUIRED	)
FIND_PACKAGE ( OpenGL		REQUIRED	)
FIND_LIBRARY ( PQXX			pqxx		)
FIND_LIBRARY ( LOX			lox			)

INCLUDE_DIRECTORIES ( AFTER ${PostgreSQL_INCLUDE_DIR} )

SET ( GMM_LIBRARIES ${LOX} ${PostgreSQL_LIBRARIES} ${PQXX} ${OPENGL_LIBRARIES} )
