/* GMM (C) 2018 Stephane Charette <stephanecharette@gmail.com>
 * $Id: GMMLookAndFeel.cpp 2601 2018-09-15 20:40:24Z stephane $
 */

#include "GMMLookAndFeel.hpp"


GMMLookAndFeel *init_gmm_look_and_feel(void)
{
	LookAndFeel_V4::ColourScheme colour_scheme(
		Colour( 0xCC, 0xDD, 0xCC ),		// window background
		Colour( 0xFF, 0xFF, 0xFF ),		// widget background, like popups and progress bar window
		Colours::white,					// menu background
		Colours::black,					// outline drawn around some controls like entryfields
		Colours::black,					// default text colour
		Colours::black,					// default fill
		Colours::white,					// highlighted text
		Colour( 0x40, 0x40, 0x40 ),		// highlighted fill
		Colours::black					// menu text
	);

	GMMLookAndFeel *laf = new GMMLookAndFeel(colour_scheme);

	LookAndFeel::setDefaultLookAndFeel(laf);

	return laf;
}


void reset_gmm_look_and_feel(void)
{
	LookAndFeel::setDefaultLookAndFeel(nullptr);

	return;
}


GMMLookAndFeel::GMMLookAndFeel( LookAndFeel_V4::ColourScheme colour_scheme ) :
		LookAndFeel_V4( colour_scheme )
{
	return;
}


GMMLookAndFeel::~GMMLookAndFeel( void )
{
	return;
}


void GMMLookAndFeel::drawCallOutBoxBackground( CallOutBox &box, Graphics &g, const Path &path, Image &cachedImage )
{
	// copied from the original juce LookAndFeel, but uses a different background colour
	
	if ( cachedImage.isNull() )
	{
		cachedImage = Image( Image::ARGB, box.getWidth(), box.getHeight(), true );
		Graphics g2( cachedImage );
		DropShadow (Colours::black.withAlpha(0.7f), 8, Point<int>(0, 2) ).drawForPath( g2, path );
	}
	
	// draw the drop shadow
	g.setColour( Colours::black );
	g.drawImageAt( cachedImage, 0, 0 );
	
	// fill the inner portion of the callout box
	g.setColour( Colour(0xCC, 0xDD, 0xCC).withAlpha(0.9f) );
	g.fillPath( path );
	
	// draw a thin outside outline
	g.setColour( Colour(0x44, 0x88, 0x66).withAlpha(0.9f) );
	g.strokePath( path, PathStrokeType( 2.0f ) );
	
	return;
}
