/* GMM (C) 2018 Stephane Charette <stephanecharette@gmail.com>
 * $Id: GMMWnd.hpp 2603 2018-09-17 08:30:49Z stephane $
 */

#include "GMM.hpp"


Notebook::Notebook(void) :
	TabbedComponent(TabbedButtonBar::Orientation::TabsAtTop)
{
	return;
}


Notebook::~Notebook(void)
{
	return;
}


void Notebook::currentTabChanged(int newCurrentTabIndex, const String & newCurrentTabName)
{
	const Colour window_background = gmm().laf->getCurrentColourScheme().getUIColour(LookAndFeel_V4::ColourScheme::windowBackground);
	const Colour active_background = window_background.withMultipliedSaturation(2.0);

	for (int idx = 0; idx < getNumTabs(); idx ++)
	{
		TabCanvas *canvas = dynamic_cast<TabCanvas*>(getTabContentComponent(idx));
		if (idx == newCurrentTabIndex)
		{
			canvas->tab_is_active = true;
			setTabBackgroundColour(idx, active_background);
		}
		else
		{
			canvas->tab_is_active = false;
			setTabBackgroundColour(idx, window_background);
		}
	}

	return;
}
