/* GMM (C) 2018 Stephane Charette <stephanecharette@gmail.com>
 * $Id: GMMWnd.cpp 2609 2018-09-18 20:01:38Z stephane $
 */

#include "GMM.hpp"
#include "src-img.hpp"


GMMWnd::GMMWnd(void) :
	DocumentWindow(
		"GMM v"  + String(GMM_VERSION),
		Desktop::getInstance().getDefaultLookAndFeel().findColour(ResizableWindow::backgroundColourId),
		DocumentWindow::TitleBarButtons::allButtons)
{
	// Even though we attempt to set the initial colour of the tab here, the notebook has also been modified
	// to edit the colour of the active/inactive tabs.  For more details, see Notebook::currentTabChanged().
	const Colour bgColour = gmm().laf->getCurrentColourScheme().getUIColour(LookAndFeel_V4::ColourScheme::windowBackground);

	// create a new tab for every device
	for (const auto & prefix : gmm().prefixes)
	{
		const std::string name = cfg().get_str(prefix + "_name", prefix);
		notebook.addTab(name, bgColour, new TabCanvas(prefix), true);
	}

	setContentNonOwned( &notebook, false );

	centreWithSize			( 640, 480		);
	setUsingNativeTitleBar	( true			);
	setResizable			( true, true	);
	setDropShadowEnabled	( true			);

	setIcon(GormanLogo());
	ComponentPeer *peer = getPeer();
	if (peer)
	{
		peer->setIcon(GormanLogo());
	}

	if (cfg().containsKey("GMMWnd"))
	{
		restoreWindowStateFromString( cfg().getValue("GMMWnd") );
	}

	setVisible(true);

	return;
}


GMMWnd::~GMMWnd(void)
{
	cfg().setValue("GMMWnd", getWindowStateAsString());

	return;
}


void GMMWnd::closeButtonPressed(void)
{
	run(GMMApplication::EJob::kShutdown);

	return;
}


bool GMMWnd::keyPressed(const KeyPress &key)
{
	const ModifierKeys modifiers = key.getModifiers();
	if (key.isKeyCode(KeyPress::F1Key))
	{
		run(GMMApplication::EJob::kShowAboutWindow);
		return true; // true == consume the keystroke
	}
	else if (key.isKeyCode(KeyPress::F2Key) && modifiers.isShiftDown())
	{
		File f = cfg().getFile();
		f.revealToUser();
		return true; // true == consume the keystroke
	}
	else if (key.isKeyCode(KeyPress::F4Key) && modifiers.isShiftDown())
	{
		File f( get_log_filename() );
		f.startAsProcess();
		return true; // true == consume the keystroke
	}

	return false; // false == keystroke not handled
}
