/* GMM (C) 2018 Stephane Charette <stephanecharette@gmail.com>
 * $Id: SerialCommWin32.cpp 2629 2018-10-12 07:02:08Z stephane $
 */


/** @file
 * This file contains sample data obtained from Dominic in October 2018
 * and is used to simulate data read from the serial port.
 */


#include "GMM.hpp"


static const std::vector<std::string> sample_data =
{
	"14.8\t14.2\r\n", "15.6\t15.0\r\n", "16.0\t15.1\r\n", "15.4\t14.8\r\n", "14.2\t13.5\r\n", "16.4\t15.6\r\n", "28.0\t21.2\r\n", "15.3\t14.4\r\n", "14.4\t13.6\r\n", "14.8\t13.5\r\n",
	"14.5\t13.3\r\n", "15.5\t14.1\r\n", "16.2\t15.1\r\n", "14.8\t13.7\r\n", "15.2\t14.4\r\n", "16.6\t15.9\r\n", "14.1\t13.4\r\n", "23.6\t16.9\r\n", "14.0\t13.3\r\n", "16.3\t15.2\r\n",
	"15.3\t14.7\r\n", "14.8\t14.2\r\n", "15.3\t13.7\r\n", "14.1\t13.4\r\n", "15.5\t14.7\r\n", "14.4\t13.6\r\n", "15.0\t14.1\r\n", "16.3\t15.2\r\n", "15.4\t14.6\r\n", "14.3\t13.8\r\n",
	"14.7\t14.1\r\n", "16.1\t14.9\r\n", "15.4\t14.5\r\n", "16.2\t15.2\r\n", "15.2\t14.5\r\n", "14.4\t13.6\r\n", "15.4\t14.2\r\n", "14.7\t13.9\r\n", "14.6\t13.8\r\n", "14.0\t13.4\r\n",
	"14.1\t13.3\r\n", "15.8\t14.6\r\n", "14.4\t13.6\r\n", "14.1\t13.5\r\n", "14.3\t13.6\r\n", "13.9\t13.2\r\n", "16.4\t15.6\r\n", "14.8\t14.2\r\n", "14.6\t14.0\r\n", "13.6\t12.9\r\n",
	"15.8\t14.9\r\n", "14.4\t13.8\r\n", "14.6\t13.4\r\n", "15.9\t15.0\r\n", "15.6\t14.7\r\n", "14.7\t13.9\r\n", "15.8\t14.8\r\n", "15.6\t14.4\r\n", "13.6\t12.9\r\n", "13.9\t13.4\r\n",
	"14.2\t13.6\r\n", "14.4\t13.5\r\n", "14.2\t13.6\r\n", "15.5\t14.7\r\n", "15.2\t14.6\r\n", "17.9\t16.4\r\n", "16.1\t15.3\r\n", "14.6\t14.1\r\n", "15.2\t14.4\r\n", "15.1\t14.4\r\n",
	"14.4\t13.8\r\n", "16.7\t14.8\r\n", "14.6\t14.0\r\n", "14.8\t14.3\r\n", "13.6\t13.0\r\n", "15.5\t13.9\r\n", "14.3\t13.8\r\n", "16.5\t15.4\r\n", "15.2\t14.2\r\n", "14.6\t13.8\r\n",
	"14.8\t14.2\r\n", "13.6\t13.2\r\n", "13.4\t12.5\r\n", "14.4\t13.6\r\n", "15.4\t14.6\r\n", "17.6\t15.5\r\n", "15.1\t14.4\r\n", "14.9\t14.0\r\n", "14.5\t13.8\r\n", "15.3\t14.5\r\n",
	"15.4\t14.7\r\n", "14.2\t13.5\r\n", "14.5\t13.9\r\n", "14.6\t13.7\r\n", "14.5\t13.9\r\n", "15.4\t14.1\r\n", "15.6\t14.8\r\n", "15.3\t14.6\r\n", "18.3\t16.2\r\n", "14.4\t13.8\r\n",
	"13.9\t13.2\r\n", "14.2\t13.5\r\n", "15.8\t14.9\r\n", "15.4\t14.2\r\n", "17.1\t16.0\r\n", "15.3\t14.4\r\n", "16.7\t15.8\r\n", "14.9\t14.3\r\n", "13.9\t13.3\r\n", "14.8\t14.0\r\n",
	"14.5\t13.9\r\n", "15.9\t15.1\r\n", "13.8\t12.9\r\n", "16.6\t15.6\r\n", "16.0\t15.1\r\n", "14.6\t13.9\r\n", "14.9\t14.1\r\n", "15.6\t14.5\r\n", "13.6\t12.7\r\n", "16.6\t15.2\r\n",
	"14.5\t13.7\r\n", "15.3\t14.8\r\n", "13.8\t13.2\r\n", "13.9\t13.4\r\n", "14.8\t13.9\r\n", "14.9\t14.1\r\n", "15.6\t14.9\r\n", "14.5\t13.7\r\n", "15.4\t14.1\r\n", "16.5\t15.2\r\n",
	"15.0\t14.4\r\n", "15.2\t14.2\r\n", "14.3\t13.5\r\n", "13.9\t13.0\r\n", "14.1\t13.4\r\n", "14.6\t13.7\r\n", "14.8\t14.1\r\n", "17.0\t15.2\r\n", "14.8\t14.2\r\n", "14.8\t14.2\r\n",
	"15.4\t14.7\r\n", "16.2\t15.2\r\n", "17.2\t16.0\r\n", "14.2\t13.5\r\n", "15.9\t14.3\r\n", "15.3\t14.1\r\n", "16.3\t14.4\r\n", "16.1\t14.6\r\n", "14.8\t14.0\r\n", "16.6\t14.8\r\n",
	"16.0\t15.4\r\n", "16.7\t15.9\r\n", "15.0\t14.4\r\n", "14.3\t13.5\r\n", "14.3\t13.8\r\n", "16.2\t15.5\r\n", "14.5\t13.9\r\n", "16.7\t15.6\r\n", "16.8\t15.9\r\n", "14.9\t14.2\r\n",
	"15.0\t14.3\r\n", "15.9\t14.5\r\n", "15.3\t14.6\r\n", "15.2\t14.5\r\n", "15.8\t14.9\r\n", "15.0\t14.0\r\n", "14.4\t13.5\r\n", "14.9\t14.3\r\n", "14.1\t13.5\r\n", "15.2\t14.4\r\n",
	"14.5\t13.8\r\n", "14.8\t14.1\r\n", "14.2\t13.2\r\n", "15.8\t15.2\r\n", "16.5\t15.7\r\n", "17.1\t16.1\r\n", "16.5\t15.6\r\n", "14.8\t14.1\r\n", "15.4\t14.6\r\n", "15.7\t14.8\r\n",
	"14.0\t12.7\r\n", "14.5\t13.7\r\n", "14.7\t14.1\r\n", "15.9\t15.2\r\n", "15.4\t14.7\r\n", "14.6\t14.1\r\n", "14.7\t14.2\r\n", "14.2\t13.5\r\n", "15.8\t15.2\r\n", "14.6\t14.1\r\n",
	"15.0\t14.4\r\n", "16.2\t15.2\r\n", "14.5\t13.8\r\n", "14.9\t14.3\r\n", "15.3\t14.5\r\n", "15.3\t14.4\r\n", "15.9\t15.1\r\n", "14.6\t14.1\r\n", "14.2\t13.6\r\n", "15.2\t14.4\r\n",
	"15.5\t14.0\r\n", "14.8\t14.3\r\n", "14.9\t14.1\r\n", "16.1\t15.3\r\n", "15.7\t14.9\r\n", "14.4\t13.9\r\n", "15.8\t15.1\r\n", "14.9\t14.1\r\n", "14.5\t13.9\r\n", "15.6\t14.3\r\n",
	"15.7\t14.9\r\n", "14.7\t14.1\r\n", "15.9\t14.8\r\n", "14.4\t13.9\r\n", "15.7\t14.9\r\n", "15.0\t14.4\r\n", "15.8\t15.1\r\n", "15.9\t15.2\r\n", "15.2\t14.4\r\n", "21.2\t17.3\r\n",
	"15.2\t14.2\r\n", "15.2\t14.1\r\n", "14.3\t13.7\r\n", "15.7\t14.9\r\n", "16.0\t14.0\r\n", "28.0\t20.4\r\n", "13.6\t12.8\r\n", "15.4\t14.4\r\n", "15.4\t14.5\r\n", "16.1\t15.3\r\n",
	"17.5\t16.3\r\n", "14.6\t13.6\r\n", "14.5\t13.8\r\n", "15.6\t15.0\r\n", "15.3\t14.7\r\n", "15.1\t14.6\r\n", "14.6\t14.0\r\n", "15.8\t15.0\r\n", "13.8\t13.3\r\n", "14.0\t13.2\r\n",
	"15.0\t14.2\r\n", "14.9\t14.2\r\n", "15.6\t14.5\r\n", "14.7\t14.0\r\n", "15.2\t14.4\r\n", "13.5\t12.9\r\n", "14.3\t13.4\r\n", "14.2\t13.5\r\n", "15.2\t14.2\r\n", "14.0\t13.1\r\n",
	"14.7\t14.0\r\n", "16.5\t14.8\r\n", "27.5\t16.4\r\n", "14.2\t13.7\r\n", "14.8\t14.0\r\n", "13.8\t13.1\r\n", "14.4\t13.4\r\n", "13.8\t13.2\r\n", "15.6\t14.7\r\n", "14.6\t13.9\r\n",
	"13.2\t12.7\r\n", "13.9\t13.0\r\n", "13.9\t12.9\r\n", "14.3\t13.6\r\n", "13.8\t13.2\r\n", "13.5\t12.6\r\n", "14.4\t13.7\r\n", "13.8\t13.1\r\n", "15.0\t14.2\r\n", "14.2\t13.4\r\n",
	"14.4\t13.6\r\n", "13.6\t12.9\r\n", "13.5\t12.8\r\n", "13.8\t13.1\r\n", "13.9\t13.3\r\n", "14.1\t13.6\r\n", "15.0\t13.7\r\n", "14.2\t12.6\r\n", "13.0\t12.5\r\n", "13.5\t12.9\r\n",
	"14.7\t13.8\r\n", "14.4\t13.6\r\n", "14.0\t13.3\r\n", "14.0\t13.1\r\n", "13.8\t13.1\r\n", "14.3\t13.3\r\n", "13.3\t12.6\r\n", "15.6\t14.8\r\n", "13.9\t13.1\r\n", "13.9\t13.2\r\n",
	"13.9\t13.0\r\n", "15.1\t14.4\r\n", "13.0\t12.3\r\n", "13.4\t12.5\r\n", "14.0\t13.1\r\n", "13.9\t13.4\r\n", "15.4\t14.7\r\n", "15.5\t14.2\r\n", "14.2\t13.5\r\n", "13.6\t12.6\r\n",
	"14.4\t13.5\r\n", "14.5\t13.6\r\n", "14.0\t13.4\r\n", "14.8\t14.0\r\n", "14.0\t13.4\r\n", "14.0\t13.0\r\n", "13.2\t12.5\r\n", "14.7\t14.1\r\n", "14.5\t13.3\r\n", "14.6\t13.9\r\n",
	"14.5\t13.4\r\n", "13.4\t12.8\r\n", "13.8\t12.9\r\n", "13.7\t13.0\r\n", "12.8\t12.4\r\n", "14.4\t13.7\r\n", "14.9\t14.2\r\n", "13.5\t12.9\r\n", "14.4\t13.9\r\n", "13.6\t13.0\r\n",
	"14.5\t13.6\r\n", "14.6\t13.8\r\n", "14.8\t13.7\r\n", "13.7\t13.0\r\n", "15.1\t14.2\r\n", "15.6\t14.5\r\n", "13.7\t13.0\r\n", "12.8\t12.2\r\n", "14.3\t13.4\r\n", "14.9\t13.6\r\n",
	"14.2\t13.6\r\n", "16.0\t14.4\r\n", "14.8\t13.9\r\n", "15.2\t13.7\r\n", "14.1\t13.4\r\n", "14.3\t13.5\r\n", "13.9\t12.9\r\n", "13.9\t13.4\r\n", "15.6\t14.8\r\n", "13.2\t12.6\r\n",
	"15.6\t14.4\r\n", "14.4\t13.5\r\n", "14.8\t14.1\r\n", "13.1\t12.5\r\n", "14.0\t13.5\r\n", "15.8\t14.6\r\n", "14.5\t12.9\r\n", "16.3\t15.1\r\n", "13.4\t12.8\r\n", "14.9\t13.6\r\n",
	"14.6\t13.8\r\n", "15.7\t13.5\r\n", "15.1\t13.2\r\n", "14.0\t13.5\r\n", "14.2\t13.4\r\n", "14.4\t13.7\r\n", "15.0\t13.9\r\n", "14.1\t13.2\r\n", "14.1\t13.6\r\n", "14.4\t13.3\r\n",
	"14.0\t13.3\r\n", "14.0\t13.3\r\n", "14.8\t14.1\r\n", "14.2\t13.2\r\n", "14.2\t13.6\r\n", "13.5\t12.5\r\n", "14.5\t13.8\r\n", "14.1\t13.3\r\n", "17.0\t15.8\r\n", "15.0\t13.9\r\n",
	"14.1\t13.5\r\n", "14.6\t13.7\r\n", "14.3\t13.5\r\n", "13.8\t13.2\r\n", "15.4\t14.7\r\n", "14.5\t13.7\r\n", "14.0\t13.1\r\n", "15.4\t14.5\r\n", "13.7\t13.2\r\n", "13.6\t13.0\r\n",
	"15.6\t14.8\r\n", "14.4\t13.6\r\n", "15.2\t13.7\r\n", "15.2\t14.3\r\n", "14.8\t13.9\r\n", "13.9\t13.2\r\n", "14.6\t13.4\r\n", "14.5\t13.8\r\n", "14.7\t13.7\r\n", "14.0\t13.4\r\n",
	"14.1\t13.3\r\n", "13.4\t12.8\r\n", "13.3\t12.6\r\n", "14.8\t14.0\r\n", "13.7\t12.9\r\n", "13.9\t13.1\r\n", "14.7\t13.8\r\n", "13.3\t12.6\r\n", "14.1\t13.4\r\n", "14.8\t13.9\r\n",
	"14.5\t13.7\r\n", "13.9\t13.2\r\n", "14.3\t13.7\r\n", "13.6\t13.0\r\n", "14.2\t13.6\r\n", "14.7\t14.1\r\n", "13.8\t13.3\r\n", "13.8\t13.2\r\n", "14.6\t13.9\r\n", "13.5\t12.6\r\n",
	"15.5\t14.5\r\n", "14.6\t13.6\r\n", "14.8\t13.8\r\n", "14.4\t13.5\r\n", "14.0\t13.4\r\n", "13.9\t13.2\r\n", "14.0\t12.9\r\n", "14.0\t13.1\r\n", "14.9\t14.1\r\n", "14.9\t14.2\r\n",
	"14.0\t13.4\r\n", "15.4\t14.4\r\n", "13.8\t12.9\r\n", "13.4\t12.6\r\n", "14.4\t13.2\r\n", "15.7\t14.6\r\n", "15.6\t14.5\r\n", "14.4\t13.6\r\n", "16.9\t15.3\r\n", "14.0\t13.3\r\n",
	"14.2\t13.3\r\n", "15.8\t14.7\r\n", "14.0\t13.1\r\n", "13.7\t12.9\r\n", "13.7\t12.9\r\n", "13.8\t13.0\r\n", "14.5\t14.0\r\n", "14.0\t13.4\r\n", "13.4\t12.7\r\n", "14.0\t13.3\r\n",
	"15.0\t14.2\r\n", "15.1\t13.7\r\n", "13.8\t13.1\r\n", "13.9\t12.8\r\n", "16.1\t15.0\r\n", "13.6\t12.7\r\n", "15.0\t13.8\r\n", "14.3\t13.5\r\n", "14.1\t13.3\r\n", "14.4\t13.8\r\n",
	"13.8\t12.8\r\n", "14.0\t13.1\r\n", "15.7\t14.9\r\n", "13.6\t12.8\r\n", "13.7\t13.1\r\n", "15.1\t14.1\r\n", "13.2\t12.6\r\n", "15.8\t14.2\r\n", "14.4\t13.7\r\n", "13.5\t12.5\r\n",
	"13.3\t12.5\r\n", "13.4\t12.7\r\n", "14.3\t13.2\r\n", "15.4\t14.2\r\n", "14.5\t13.8\r\n", "14.2\t13.5\r\n", "14.2\t13.3\r\n", "13.1\t12.1\r\n", "13.7\t13.1\r\n", "13.2\t12.2\r\n",
	"13.8\t13.0\r\n", "14.7\t12.7\r\n", "12.9\t12.1\r\n", "12.6\t12.0\r\n", "13.4\t12.6\r\n", "15.5\t13.8\r\n", "12.8\t12.2\r\n", "15.5\t14.7\r\n", "12.9\t12.0\r\n", "15.7\t14.9\r\n",
	"12.6\t12.1\r\n", "15.5\t14.2\r\n", "14.5\t13.8\r\n", "15.5\t14.6\r\n", "14.0\t13.3\r\n", "13.9\t12.8\r\n", "15.8\t14.9\r\n", "14.4\t13.5\r\n", "15.4\t14.6\r\n", "13.4\t12.8\r\n",
	"14.4\t13.5\r\n", "14.8\t13.8\r\n", "12.3\t11.5\r\n", "27.4\t15.0\r\n", "13.7\t12.9\r\n", "14.9\t14.1\r\n", "16.3\t15.3\r\n", "14.6\t13.5\r\n", "13.9\t13.0\r\n", "15.4\t14.6\r\n",
	"15.2\t14.4\r\n", "13.7\t13.0\r\n", "15.4\t14.1\r\n", "14.2\t13.4\r\n", "14.0\t13.3\r\n", "15.2\t14.0\r\n", "17.7\t16.5\r\n", "20.2\t14.9\r\n", "14.8\t13.7\r\n", "15.0\t14.1\r\n",
	"13.6\t12.6\r\n", "13.7\t13.2\r\n", "13.6\t12.8\r\n", "13.8\t12.9\r\n", "13.6\t12.9\r\n", "14.3\t13.7\r\n", "16.3\t15.3\r\n", "13.6\t12.8\r\n", "14.2\t13.4\r\n", "14.9\t14.0\r\n",
	"14.6\t13.5\r\n", "13.7\t12.7\r\n", "13.9\t13.0\r\n", "14.0\t12.8\r\n", "14.8\t14.0\r\n", "13.5\t12.7\r\n", "14.4\t13.7\r\n", "15.4\t14.8\r\n", "15.3\t14.5\r\n", "13.9\t13.2\r\n",
	"13.7\t13.2\r\n", "15.0\t14.2\r\n", "16.0\t15.0\r\n", "14.8\t13.9\r\n", "15.2\t14.0\r\n", "14.3\t13.7\r\n", "15.6\t14.5\r\n", "13.8\t12.9\r\n", "13.3\t12.6\r\n", "14.3\t13.4\r\n",
	"14.9\t14.0\r\n", "13.6\t12.9\r\n", "14.4\t13.5\r\n", "14.0\t13.3\r\n", "14.2\t12.8\r\n", "13.1\t12.3\r\n", "14.4\t13.5\r\n", "15.5\t14.4\r\n", "14.6\t13.3\r\n", "16.4\t15.4\r\n",
	"13.0\t12.0\r\n", "13.8\t12.8\r\n", "16.0\t14.9\r\n", "13.6\t12.3\r\n", "15.3\t14.1\r\n", "14.5\t13.5\r\n", "16.3\t15.4\r\n", "13.3\t12.6\r\n", "14.4\t13.7\r\n", "13.6\t12.9\r\n",
	"14.3\t13.2\r\n", "14.2\t13.6\r\n", "15.0\t14.1\r\n", "13.8\t13.3\r\n", "16.0\t14.9\r\n", "14.4\t13.5\r\n", "14.1\t12.9\r\n", "13.7\t13.0\r\n", "15.7\t14.3\r\n", "14.1\t13.3\r\n",
	"13.4\t12.2\r\n", "13.9\t13.0\r\n", "16.5\t15.3\r\n", "14.7\t13.9\r\n", "14.4\t13.5\r\n", "15.3\t14.4\r\n", "13.9\t13.3\r\n", "13.4\t12.6\r\n", "17.3\t16.4\r\n", "14.2\t13.4\r\n",
	"15.3\t14.4\r\n", "15.0\t14.0\r\n", "16.1\t15.0\r\n", "28.0\t21.3\r\n", "15.3\t13.8\r\n", "13.5\t12.8\r\n", "15.2\t13.9\r\n", "13.6\t12.6\r\n", "14.4\t13.3\r\n", "14.9\t14.0\r\n",
	"15.1\t14.2\r\n", "13.8\t13.0\r\n", "14.0\t13.4\r\n", "13.4\t12.3\r\n", "27.8\t14.8\r\n", "14.8\t13.9\r\n", "15.7\t14.6\r\n", "16.5\t15.4\r\n", "13.9\t13.0\r\n", "14.4\t13.1\r\n",
	"15.3\t14.0\r\n", "17.6\t16.2\r\n", "15.6\t14.4\r\n", "14.9\t13.9\r\n", "12.8\t12.1\r\n", "15.6\t14.8\r\n", "15.7\t14.8\r\n", "14.1\t13.3\r\n", "15.3\t13.8\r\n", "15.2\t14.7\r\n",
	"14.1\t13.4\r\n", "14.3\t13.5\r\n", "14.2\t13.3\r\n", "13.9\t13.1\r\n", "12.8\t12.1\r\n", "14.0\t13.3\r\n", "15.2\t14.0\r\n", "16.1\t15.1\r\n", "15.4\t14.2\r\n", "15.0\t14.2\r\n",
	"14.3\t13.7\r\n", "13.8\t12.8\r\n", "13.7\t12.9\r\n", "16.5\t15.2\r\n", "13.8\t13.2\r\n", "14.2\t13.5\r\n", "15.4\t13.9\r\n", "14.6\t13.6\r\n", "14.5\t13.7\r\n", "15.0\t13.9\r\n",
	"13.8\t13.1\r\n", "13.2\t12.5\r\n", "14.1\t13.4\r\n", "14.2\t13.5\r\n", "15.9\t14.8\r\n", "14.7\t13.9\r\n", "13.8\t13.2\r\n", "14.2\t13.6\r\n", "15.2\t13.8\r\n", "14.4\t13.6\r\n",
	"14.9\t14.1\r\n", "14.7\t13.9\r\n", "13.7\t12.8\r\n", "14.4\t13.4\r\n", "14.4\t13.2\r\n", "15.2\t13.9\r\n", "14.0\t13.3\r\n", "14.1\t13.3\r\n", "15.1\t13.9\r\n", "16.3\t14.9\r\n",
	"15.1\t14.1\r\n", "13.9\t13.0\r\n", "13.9\t13.1\r\n", "14.4\t13.8\r\n", "14.8\t13.8\r\n", "14.2\t13.4\r\n", "13.5\t12.8\r\n", "14.7\t13.9\r\n", "15.4\t14.6\r\n", "15.4\t14.2\r\n",
	"17.5\t15.7\r\n", "15.2\t14.2\r\n", "13.2\t12.6\r\n", "14.9\t13.2\r\n", "14.0\t13.2\r\n", "14.6\t13.7\r\n", "13.9\t13.0\r\n", "13.8\t12.9\r\n", "16.9\t16.1\r\n", "15.3\t13.1\r\n",
	"14.1\t13.1\r\n", "13.4\t12.8\r\n", "14.0\t13.3\r\n", "15.3\t14.4\r\n", "13.3\t12.5\r\n", "14.3\t13.4\r\n", "15.2\t14.5\r\n", "13.8\t12.7\r\n", "13.9\t13.2\r\n", "14.7\t13.2\r\n",
	"13.9\t13.0\r\n", "14.8\t13.9\r\n", "16.4\t15.1\r\n", "12.8\t12.1\r\n", "17.5\t16.6\r\n", "13.2\t12.4\r\n", "17.0\t15.9\r\n", "13.5\t12.8\r\n", "14.3\t13.1\r\n", "13.9\t13.2\r\n",
	"14.0\t13.2\r\n", "14.4\t13.7\r\n", "15.2\t14.3\r\n", "14.1\t13.3\r\n", "17.1\t16.0\r\n", "14.5\t13.7\r\n", "14.7\t13.9\r\n", "14.1\t13.1\r\n", "13.7\t13.0\r\n", "15.0\t14.2\r\n",
	"17.5\t16.4\r\n", "14.7\t14.0\r\n", "13.4\t12.4\r\n", "15.3\t14.4\r\n", "16.3\t15.2\r\n", "13.3\t12.6\r\n", "14.8\t13.9\r\n", "14.8\t13.8\r\n", "15.2\t14.3\r\n", "13.9\t12.8\r\n",
	"13.5\t12.9\r\n", "13.5\t12.8\r\n", "13.7\t13.0\r\n", "16.1\t15.2\r\n", "13.7\t13.0\r\n", "14.2\t12.8\r\n", "14.3\t13.7\r\n", "13.5\t12.8\r\n", "14.3\t13.5\r\n", "14.3\t13.3\r\n",
	"14.2\t13.0\r\n", "13.5\t12.8\r\n", "17.0\t15.3\r\n", "15.8\t14.8\r\n", "14.3\t13.4\r\n", "15.0\t14.1\r\n", "16.2\t15.3\r\n", "13.6\t13.0\r\n", "13.9\t12.9\r\n", "14.2\t13.4\r\n",
	"14.3\t13.4\r\n", "13.6\t12.9\r\n", "13.8\t13.1\r\n", "14.8\t14.2\r\n", "13.6\t12.6\r\n", "14.3\t13.6\r\n", "14.7\t13.9\r\n", "12.9\t12.0\r\n", "14.3\t13.3\r\n", "16.3\t15.2\r\n",
	"15.7\t14.3\r\n", "14.0\t13.4\r\n", "14.6\t13.3\r\n", "14.7\t13.5\r\n", "16.9\t14.8\r\n", "13.3\t12.6\r\n", "14.5\t13.8\r\n", "14.6\t13.9\r\n", "14.9\t14.3\r\n", "12.8\t12.1\r\n",
	"14.8\t14.0\r\n", "14.4\t13.6\r\n", "14.5\t13.7\r\n", "17.4\t15.4\r\n", "15.1\t13.9\r\n", "15.2\t14.1\r\n", "15.5\t14.6\r\n", "13.9\t13.1\r\n", "17.1\t15.7\r\n", "15.1\t14.2\r\n",
	"15.4\t14.4\r\n", "14.5\t13.6\r\n", "15.9\t14.9\r\n", "13.4\t12.7\r\n", "15.6\t15.0\r\n", "13.2\t12.4\r\n", "14.1\t13.4\r\n", "14.2\t13.2\r\n", "13.6\t12.8\r\n", "16.6\t14.9\r\n",
	"16.2\t14.9\r\n", "24.5\t15.7\r\n", "14.4\t13.4\r\n", "14.6\t13.8\r\n", "13.3\t12.4\r\n", "13.9\t13.1\r\n", "13.6\t12.9\r\n", "13.8\t13.0\r\n", "15.4\t14.6\r\n", "13.7\t12.9\r\n",
	"14.2\t13.5\r\n", "15.6\t14.6\r\n", "15.1\t14.0\r\n", "16.1\t14.3\r\n", "16.3\t15.1\r\n", "16.0\t15.0\r\n", "15.4\t14.4\r\n", "14.6\t13.6\r\n", "14.7\t13.5\r\n", "13.6\t12.9\r\n",
	"14.8\t13.6\r\n", "16.7\t15.9\r\n", "15.1\t14.0\r\n", "15.5\t14.3\r\n", "15.0\t13.8\r\n", "14.4\t13.9\r\n", "13.9\t13.1\r\n", "14.1\t13.4\r\n", "15.0\t13.3\r\n", "16.1\t15.2\r\n",
	"13.7\t12.9\r\n", "14.2\t13.5\r\n", "14.6\t14.0\r\n", "15.9\t13.5\r\n", "15.2\t14.5\r\n", "13.8\t13.0\r\n", "13.1\t12.4\r\n", "16.9\t14.0\r\n", "15.8\t14.8\r\n", "14.3\t13.6\r\n",
	"13.9\t13.3\r\n", "14.9\t14.3\r\n", "13.7\t13.2\r\n", "14.6\t14.0\r\n", "13.1\t12.6\r\n", "14.0\t13.2\r\n", "13.8\t13.1\r\n", "13.7\t12.7\r\n", "16.0\t15.1\r\n", "14.6\t13.8\r\n",
	"13.2\t12.6\r\n", "14.9\t13.7\r\n", "13.8\t13.1\r\n", "13.8\t13.1\r\n", "13.3\t12.5\r\n", "14.2\t12.5\r\n", "17.9\t16.2\r\n", "14.0\t13.1\r\n", "13.4\t12.7\r\n", "16.8\t15.7\r\n",
	"13.7\t13.0\r\n", "16.3\t14.8\r\n", "13.5\t12.7\r\n", "16.4\t14.8\r\n", "14.8\t14.0\r\n", "17.4\t15.5\r\n", "16.7\t15.5\r\n", "14.7\t13.9\r\n", "14.4\t13.6\r\n", "13.6\t12.8\r\n",
	"14.1\t13.2\r\n", "15.4\t14.6\r\n", "16.0\t15.1\r\n", "14.6\t13.7\r\n", "13.5\t12.7\r\n", "14.7\t13.7\r\n", "13.0\t12.4\r\n", "14.2\t13.4\r\n", "14.3\t13.3\r\n", "14.4\t13.3\r\n",
	"14.9\t14.0\r\n", "13.6\t13.0\r\n", "15.0\t14.3\r\n", "14.9\t13.8\r\n", "15.7\t14.1\r\n", "13.9\t13.3\r\n", "14.4\t13.7\r\n", "14.4\t13.7\r\n", "13.8\t13.1\r\n", "15.0\t13.7\r\n",
	"13.5\t12.9\r\n", "14.0\t13.2\r\n", "15.3\t14.2\r\n", "15.7\t14.7\r\n", "14.5\t13.2\r\n", "15.1\t13.9\r\n", "13.6\t12.9\r\n", "15.0\t14.0\r\n", "14.0\t13.3\r\n", "15.0\t13.8\r\n",
	"14.2\t13.4\r\n", "13.2\t12.4\r\n", "14.0\t13.4\r\n", "14.4\t13.6\r\n", "15.5\t14.6\r\n", "14.8\t14.1\r\n", "13.2\t12.5\r\n", "13.7\t13.1\r\n", "14.0\t13.0\r\n", "14.9\t14.0\r\n",
	"18.6\t17.2\r\n", "16.8\t15.2\r\n", "14.1\t13.0\r\n", "15.6\t14.5\r\n", "13.9\t13.0\r\n", "13.8\t13.0\r\n", "15.5\t14.6\r\n", "13.9\t13.1\r\n", "14.0\t13.5\r\n", "14.6\t14.0\r\n",
	"14.4\t13.4\r\n", "13.7\t12.8\r\n", "13.6\t13.0\r\n", "14.2\t13.2\r\n", "15.2\t14.2\r\n", "15.6\t14.6\r\n", "13.9\t13.0\r\n", "14.6\t13.5\r\n", "14.8\t13.9\r\n", "15.8\t14.6\r\n",
	"13.4\t12.6\r\n", "13.9\t12.7\r\n", "15.5\t14.7\r\n", "14.0\t13.2\r\n", "14.7\t13.9\r\n", "14.8\t14.0\r\n", "14.9\t14.3\r\n", "14.2\t13.5\r\n", "13.2\t12.7\r\n", "13.9\t13.3\r\n",
	"15.2\t14.1\r\n", "14.6\t13.9\r\n", "13.9\t13.3\r\n", "14.4\t13.7\r\n", "14.8\t13.5\r\n", "15.6\t14.6\r\n", "14.4\t13.3\r\n", "13.9\t13.2\r\n", "14.3\t13.6\r\n", "16.1\t14.3\r\n",
	"13.6\t12.8\r\n", "15.7\t14.8\r\n", "13.8\t13.0\r\n", "14.8\t14.2\r\n", "15.0\t14.2\r\n", "16.2\t15.0\r\n", "15.9\t14.4\r\n", "14.7\t13.6\r\n", "13.9\t13.3\r\n", "13.9\t13.0\r\n",
	"14.5\t13.7\r\n", "14.3\t13.6\r\n", "16.4\t15.3\r\n", "15.1\t14.2\r\n", "13.9\t13.2\r\n", "14.2\t13.4\r\n", "14.6\t13.8\r\n", "14.8\t14.0\r\n", "15.9\t15.0\r\n", "14.2\t13.4\r\n",
	"15.1\t14.3\r\n", "14.8\t14.1\r\n", "14.4\t13.6\r\n", "13.3\t12.8\r\n", "13.7\t13.0\r\n", "14.6\t13.7\r\n", "14.1\t13.4\r\n", "14.3\t13.5\r\n", "14.8\t13.8\r\n", "14.8\t14.0\r\n",
	"13.6\t13.0\r\n", "14.2\t13.4\r\n", "14.8\t13.2\r\n", "15.0\t14.2\r\n", "13.5\t12.9\r\n", "13.5\t12.9\r\n", "15.2\t14.5\r\n", "13.9\t13.2\r\n", "13.4\t12.8\r\n", "14.9\t14.1\r\n",
	"15.2\t14.0\r\n", "14.6\t14.0\r\n", "14.9\t14.0\r\n", "14.6\t13.5\r\n", "14.0\t13.5\r\n", "12.8\t12.2\r\n", "14.2\t13.4\r\n", "14.3\t13.6\r\n", "17.4\t15.7\r\n", "15.1\t14.3\r\n",
	"14.9\t14.1\r\n", "13.8\t13.1\r\n", "13.4\t12.8\r\n", "14.6\t13.7\r\n", "14.2\t13.4\r\n", "13.5\t12.9\r\n", "15.2\t14.1\r\n", "13.5\t12.8\r\n", "13.9\t13.1\r\n", "13.2\t12.6\r\n",
	"13.1\t12.5\r\n", "14.2\t13.7\r\n", "13.8\t13.0\r\n", "13.9\t13.3\r\n", "12.9\t12.4\r\n", "14.0\t13.4\r\n", "14.2\t13.4\r\n", "13.8\t13.3\r\n", "27.9\t20.2\r\n", "13.4\t12.9\r\n",
	"13.6\t12.9\r\n", "14.2\t13.5\r\n", "14.6\t13.9\r\n", "14.0\t13.1\r\n", "15.7\t14.9\r\n", "13.7\t13.1\r\n", "13.6\t12.7\r\n", "14.1\t13.3\r\n", "13.8\t13.2\r\n", "12.9\t12.2\r\n",
	"13.7\t13.0\r\n", "13.7\t13.1\r\n", "14.4\t13.7\r\n", "13.8\t12.4\r\n", "13.5\t12.9\r\n", "13.3\t12.6\r\n", "13.4\t12.6\r\n", "13.4\t13.0\r\n", "15.3\t14.3\r\n", "13.5\t12.9\r\n",
	"13.2\t12.6\r\n", "14.4\t13.8\r\n", "13.5\t12.7\r\n", "13.8\t13.2\r\n", "15.5\t14.4\r\n", "13.2\t12.5\r\n", "14.7\t14.1\r\n", "13.4\t12.8\r\n", "13.4\t12.6\r\n", "13.1\t12.4\r\n",
	"14.2\t13.5\r\n", "15.8\t14.8\r\n", "14.0\t12.9\r\n", "14.2\t13.3\r\n", "14.2\t13.6\r\n", "14.0\t13.3\r\n", "14.2\t13.7\r\n", "18.8\t15.4\r\n", "13.9\t12.9\r\n", "14.7\t13.7\r\n",
	"15.1\t14.5\r\n", "13.6\t12.8\r\n", "14.7\t14.1\r\n", "14.0\t13.4\r\n", "16.8\t15.9\r\n", "16.6\t15.4\r\n", "14.3\t12.9\r\n", "14.9\t14.0\r\n", "14.0\t13.3\r\n", "13.2\t12.3\r\n",
	"14.3\t13.7\r\n", "14.7\t13.9\r\n", "14.8\t13.9\r\n", "13.7\t12.9\r\n", "13.9\t13.1\r\n", "13.9\t12.8\r\n", "16.3\t14.4\r\n", "13.8\t13.2\r\n", "13.6\t13.1\r\n", "14.0\t13.2\r\n",
	"14.1\t13.5\r\n", "14.7\t13.9\r\n", "13.6\t13.0\r\n", "15.2\t14.6\r\n", "14.6\t14.0\r\n", "14.8\t14.2\r\n", "13.9\t13.3\r\n", "14.4\t13.7\r\n", "13.8\t13.3\r\n", "14.0\t13.2\r\n",
	"15.5\t14.6\r\n", "13.8\t13.0\r\n", "13.5\t12.7\r\n", "14.1\t13.5\r\n", "13.9\t13.1\r\n", "15.8\t14.7\r\n", "13.2\t12.4\r\n", "13.5\t12.8\r\n", "14.8\t13.7\r\n", "14.4\t13.5\r\n",
	"14.1\t13.4\r\n", "13.6\t12.7\r\n", "14.4\t13.7\r\n", "13.7\t13.1\r\n", "14.4\t13.7\r\n", "14.1\t13.5\r\n", "14.7\t13.8\r\n", "14.0\t13.1\r\n", "14.0\t13.2\r\n", "13.7\t13.0\r\n",
	"28.0\t21.3\r\n", "14.2\t13.7\r\n", "13.3\t12.6\r\n", "14.1\t13.4\r\n", "15.6\t14.3\r\n", "14.7\t14.0\r\n", "15.3\t14.4\r\n", "13.9\t13.1\r\n", "16.1\t15.2\r\n", "13.4\t12.6\r\n",
	"13.6\t12.8\r\n", "14.1\t13.3\r\n", "14.0\t13.5\r\n", "13.4\t12.5\r\n", "13.8\t13.2\r\n", "13.4\t12.6\r\n", "13.8\t13.2\r\n", "14.2\t13.7\r\n", "13.2\t12.5\r\n", "14.3\t13.5\r\n",
	"15.0\t14.0\r\n", "13.3\t12.7\r\n", "14.9\t13.7\r\n", "14.6\t13.9\r\n", "14.2\t13.0\r\n", "14.0\t13.4\r\n", "14.3\t13.7\r\n", "14.0\t13.1\r\n", "15.2\t14.5\r\n", "14.4\t13.1\r\n",
	"13.8\t13.3\r\n", "14.3\t13.5\r\n", "14.1\t13.4\r\n", "13.8\t13.3\r\n", "13.2\t12.5\r\n", "12.8\t12.0\r\n", "13.0\t12.4\r\n", "16.9\t15.7\r\n", "13.1\t12.5\r\n", "14.0\t13.1\r\n",
	"14.9\t14.1\r\n", "13.3\t12.8\r\n", "15.3\t14.6\r\n", "13.2\t12.5\r\n", "14.2\t13.6\r\n", "13.9\t13.4\r\n", "14.4\t13.6\r\n", "13.1\t12.4\r\n", "13.9\t13.3\r\n", "14.5\t13.8\r\n",
	"13.8\t13.3\r\n", "15.0\t13.9\r\n", "23.7\t17.2\r\n", "14.4\t13.6\r\n", "13.9\t12.9\r\n", "14.0\t13.2\r\n", "13.9\t13.2\r\n", "15.2\t13.8\r\n", "14.7\t13.5\r\n", "15.6\t14.7\r\n",
	"13.8\t13.2\r\n", "14.7\t14.1\r\n", "16.3\t15.4\r\n", "14.2\t13.4\r\n", "15.4\t14.2\r\n", "15.1\t14.3\r\n", "13.2\t12.6\r\n", "14.3\t13.7\r\n", "13.5\t12.9\r\n", "14.4\t13.4\r\n",
	"13.6\t13.0\r\n", "14.5\t13.5\r\n", "13.2\t12.5\r\n", "15.0\t14.2\r\n", "13.8\t13.2\r\n", "13.9\t13.2\r\n", "14.8\t14.0\r\n", "14.5\t13.8\r\n", "14.2\t12.7\r\n", "13.8\t12.5\r\n",
	"14.6\t13.9\r\n", "14.6\t13.9\r\n", "16.1\t15.2\r\n", "15.6\t14.3\r\n", "14.6\t13.9\r\n", "14.4\t13.8\r\n", "14.2\t13.5\r\n", "13.5\t12.8\r\n", "14.9\t14.2\r\n", "14.3\t13.7\r\n",
	"14.0\t13.1\r\n", "13.1\t12.6\r\n", "24.6\t13.3\r\n", "14.6\t13.2\r\n", "14.4\t13.2\r\n", "14.1\t13.4\r\n", "14.8\t13.9\r\n", "13.3\t12.8\r\n", "13.9\t13.2\r\n", "14.1\t13.4\r\n",
	"13.8\t13.3\r\n", "14.6\t13.5\r\n", "13.2\t12.4\r\n", "14.7\t14.0\r\n", "13.8\t13.2\r\n", "14.5\t13.8\r\n", "13.7\t13.0\r\n", "13.6\t13.0\r\n", "15.0\t14.2\r\n", "14.9\t13.9\r\n",
	"13.0\t12.5\r\n", "14.5\t13.7\r\n", "15.2\t14.2\r\n", "13.7\t12.9\r\n", "14.3\t13.5\r\n", "13.0\t12.4\r\n", "15.0\t14.1\r\n", "14.2\t13.3\r\n", "14.2\t13.4\r\n", "15.1\t14.4\r\n",
	"14.1\t13.6\r\n", "13.2\t12.6\r\n", "13.3\t12.6\r\n", "13.2\t12.4\r\n", "14.9\t14.3\r\n", "14.1\t13.6\r\n", "14.2\t13.4\r\n", "14.1\t13.3\r\n", "14.1\t13.2\r\n", "13.0\t12.5\r\n",
	"13.8\t13.2\r\n", "14.0\t13.4\r\n", "14.0\t13.2\r\n", "13.2\t12.6\r\n", "16.2\t15.3\r\n", "14.1\t12.7\r\n", "13.7\t13.0\r\n", "13.2\t12.6\r\n", "13.2\t12.7\r\n", "16.4\t15.6\r\n",
	"14.3\t13.2\r\n", "13.6\t13.0\r\n", "14.6\t13.9\r\n", "14.1\t13.5\r\n", "13.9\t13.4\r\n", "14.1\t13.4\r\n", "14.5\t13.9\r\n", "13.4\t12.7\r\n", "13.3\t12.7\r\n", "13.9\t13.2\r\n",
	"13.7\t13.1\r\n", "13.3\t12.6\r\n", "13.6\t12.9\r\n", "13.6\t12.8\r\n", "14.1\t13.5\r\n", "13.7\t13.0\r\n", "14.4\t13.7\r\n", "15.0\t14.5\r\n", "14.4\t13.8\r\n", "12.4\t11.8\r\n",
	"13.5\t12.9\r\n", "13.6\t13.0\r\n", "15.7\t14.6\r\n", "14.0\t13.2\r\n", "13.6\t12.9\r\n", "15.0\t14.1\r\n", "13.6\t12.7\r\n", "13.8\t12.9\r\n", "13.3\t12.3\r\n", "14.4\t13.2\r\n",
	"14.0\t13.4\r\n", "13.4\t12.8\r\n", "13.3\t12.7\r\n", "13.0\t12.5\r\n", "15.8\t14.8\r\n", "13.5\t12.9\r\n", "15.4\t13.9\r\n", "13.2\t12.5\r\n", "14.7\t13.9\r\n", "14.0\t13.3\r\n",
	"14.1\t13.4\r\n", "15.7\t14.9\r\n", "13.5\t12.9\r\n", "13.6\t12.5\r\n", "14.3\t13.6\r\n", "13.4\t12.8\r\n", "13.5\t12.8\r\n", "13.6\t12.8\r\n", "14.0\t13.4\r\n", "14.3\t13.5\r\n",
	"13.4\t12.8\r\n", "13.9\t13.1\r\n", "12.6\t12.1\r\n", "13.8\t13.2\r\n", "13.5\t12.4\r\n", "13.4\t12.8\r\n", "15.4\t14.4\r\n", "13.8\t13.0\r\n", "13.5\t12.8\r\n", "14.8\t13.1\r\n",
	"15.8\t14.7\r\n", "15.0\t13.7\r\n", "13.8\t12.3\r\n", "12.7\t12.0\r\n", "14.5\t13.2\r\n", "13.4\t12.4\r\n", "15.0\t13.7\r\n", "17.0\t14.6\r\n", "15.1\t13.1\r\n", "14.2\t12.7\r\n",
	"15.2\t13.9\r\n", "16.6\t14.5\r\n", "16.3\t14.3\r\n", "14.4\t12.9\r\n", "13.9\t12.9\r\n", "12.9\t11.7\r\n", "21.2\t16.9\r\n", "15.0\t13.0\r\n", "13.2\t12.2\r\n", "14.5\t13.4\r\n",
	"13.2\t12.2\r\n", "14.8\t13.9\r\n", "13.2\t12.3\r\n", "15.4\t13.8\r\n", "14.0\t12.8\r\n", "13.6\t12.5\r\n", "13.9\t12.9\r\n", "14.8\t13.4\r\n", "14.8\t13.2\r\n", "14.4\t13.0\r\n",
	"13.4\t12.2\r\n", "13.0\t11.9\r\n", "15.2\t14.1\r\n", "13.8\t12.8\r\n", "12.5\t11.9\r\n", "13.1\t12.0\r\n", "13.6\t12.9\r\n", "15.3\t13.9\r\n", "14.8\t13.5\r\n", "15.5\t14.1\r\n",
	"16.5\t14.4\r\n", "14.1\t13.0\r\n", "14.2\t13.2\r\n", "14.5\t13.1\r\n", "16.5\t14.8\r\n", "14.2\t12.8\r\n", "14.7\t13.4\r\n", "13.4\t12.7\r\n", "14.3\t13.5\r\n", "16.0\t14.8\r\n",
	"14.2\t13.3\r\n", "13.1\t12.2\r\n", "14.3\t13.3\r\n", "15.6\t12.9\r\n", "13.4\t12.2\r\n", "14.6\t13.4\r\n", "15.5\t13.4\r\n", "14.3\t12.9\r\n", "14.4\t13.1\r\n", "15.0\t12.7\r\n",
	"14.0\t12.7\r\n", "13.2\t12.2\r\n", "14.7\t13.3\r\n", "14.0\t12.9\r\n", "14.4\t13.5\r\n", "14.6\t12.8\r\n", "16.7\t15.0\r\n", "14.0\t13.0\r\n", "14.4\t13.0\r\n", "15.1\t13.2\r\n",
	"14.2\t13.0\r\n", "14.4\t13.1\r\n", "13.9\t12.5\r\n", "15.9\t14.3\r\n", "13.8\t12.1\r\n", "14.8\t13.2\r\n", "14.8\t13.6\r\n", "15.4\t14.0\r\n", "15.4\t14.1\r\n", "16.0\t14.2\r\n",
	"15.2\t13.7\r\n", "14.5\t13.2\r\n", "14.0\t12.7\r\n", "12.8\t12.0\r\n", "14.7\t13.8\r\n", "14.9\t13.5\r\n", "13.8\t12.3\r\n", "16.5\t14.5\r\n", "14.2\t13.0\r\n", "16.8\t15.2\r\n",
	"14.7\t12.9\r\n", "15.2\t12.7\r\n", "14.4\t12.8\r\n", "14.9\t13.5\r\n", "14.4\t13.2\r\n", "13.2\t12.4\r\n", "16.5\t15.0\r\n", "14.6\t13.7\r\n", "14.0\t13.2\r\n", "12.7\t11.8\r\n",
	"16.5\t14.9\r\n", "16.1\t14.3\r\n", "13.6\t13.0\r\n", "14.2\t00.0\r\n", "13.9\t00.0\r\n", "13.0\t12.4\r\n", "13.9\t13.0\r\n", "13.9\t13.0\r\n", "14.4\t13.3\r\n", "14.6\t13.6\r\n",
	"13.2\t12.3\r\n", "15.8\t14.3\r\n", "14.5\t13.3\r\n", "12.7\t11.9\r\n", "13.8\t13.0\r\n", "13.3\t12.6\r\n", "13.0\t12.4\r\n", "13.4\t12.9\r\n", "13.6\t12.8\r\n", "13.5\t12.8\r\n",
	"13.7\t12.9\r\n", "28.0\t24.7\r\n", "13.6\t12.1\r\n", "14.6\t13.3\r\n", "14.3\t13.2\r\n", "13.8\t12.6\r\n", "14.3\t13.4\r\n", "13.7\t12.9\r\n", "14.4\t13.5\r\n", "13.9\t13.1\r\n",
	"13.6\t12.7\r\n", "13.9\t12.9\r\n", "12.5\t11.8\r\n", "20.8\t15.8\r\n", "18.7\t15.2\r\n", "13.0\t12.3\r\n", "13.3\t12.6\r\n", "13.5\t12.5\r\n", "15.4\t13.5\r\n", "13.0\t12.3\r\n",
	"14.7\t13.2\r\n", "14.4\t13.0\r\n", "13.2\t12.0\r\n", "14.2\t13.2\r\n", "13.7\t13.0\r\n", "14.0\t13.3\r\n", "13.7\t12.8\r\n", "13.1\t12.5\r\n", "13.9\t13.2\r\n", "13.1\t12.5\r\n",
	"15.6\t14.0\r\n", "14.0\t13.1\r\n", "13.9\t13.1\r\n", "13.8\t12.7\r\n", "14.4\t13.6\r\n", "13.9\t13.1\r\n", "14.6\t13.6\r\n", "14.9\t14.1\r\n", "14.2\t13.1\r\n", "13.7\t12.7\r\n",
	"13.9\t12.9\r\n", "13.6\t12.9\r\n", "13.6\t12.9\r\n", "13.8\t13.1\r\n", "13.1\t12.5\r\n", "13.5\t12.2\r\n", "14.3\t13.6\r\n", "13.7\t13.0\r\n", "13.8\t13.0\r\n", "13.5\t12.8\r\n",
	"13.8\t12.8\r\n", "13.5\t12.5\r\n", "13.9\t13.0\r\n", "15.0\t13.7\r\n", "13.1\t12.3\r\n", "13.6\t12.4\r\n", "13.9\t13.1\r\n", "13.8\t13.0\r\n", "14.4\t13.5\r\n", "14.6\t13.7\r\n",
	"14.2\t13.0\r\n", "13.0\t12.3\r\n", "16.1\t15.0\r\n", "13.8\t12.8\r\n", "13.5\t12.9\r\n", "14.3\t13.6\r\n", "12.7\t11.8\r\n", "14.1\t13.1\r\n", "13.9\t13.2\r\n", "12.7\t11.9\r\n",
	"13.6\t12.8\r\n", "13.3\t12.6\r\n", "13.7\t13.0\r\n", "14.7\t12.9\r\n", "13.6\t12.9\r\n", "13.8\t12.6\r\n", "13.1\t12.0\r\n", "13.4\t12.6\r\n", "14.0\t13.2\r\n", "13.4\t12.7\r\n",
	"13.6\t12.8\r\n", "15.4\t14.7\r\n", "13.2\t12.6\r\n", "13.5\t12.9\r\n", "12.9\t12.1\r\n", "13.8\t13.0\r\n", "13.6\t13.0\r\n", "12.2\t11.6\r\n", "14.0\t13.3\r\n", "13.8\t12.4\r\n",
	"13.4\t12.6\r\n", "14.6\t13.4\r\n", "14.0\t13.1\r\n", "16.0\t14.7\r\n", "13.4\t12.8\r\n", "14.0\t13.2\r\n", "13.3\t12.6\r\n", "15.4\t14.3\r\n", "14.0\t13.5\r\n", "14.6\t13.7\r\n",
	"12.9\t12.1\r\n", "13.8\t12.9\r\n", "15.1\t13.4\r\n", "14.2\t13.3\r\n", "13.8\t13.0\r\n", "14.7\t13.4\r\n", "13.8\t13.1\r\n", "13.2\t12.5\r\n", "13.1\t12.3\r\n", "13.9\t12.5\r\n",
	"14.3\t13.4\r\n", "13.9\t13.1\r\n", "13.6\t13.0\r\n", "13.0\t12.3\r\n", "13.1\t12.3\r\n", "13.8\t13.1\r\n", "15.3\t14.4\r\n", "13.6\t13.0\r\n", "13.9\t13.1\r\n", "14.2\t13.5\r\n",
	"13.7\t12.6\r\n", "15.9\t14.1\r\n", "14.9\t13.8\r\n", "12.6\t12.0\r\n", "14.3\t13.5\r\n", "13.6\t13.0\r\n", "13.4\t12.6\r\n", "13.8\t12.8\r\n", "13.8\t13.0\r\n", "13.9\t12.9\r\n",
	"13.8\t13.1\r\n", "13.6\t13.0\r\n", "14.0\t13.4\r\n", "14.5\t13.4\r\n", "14.8\t13.8\r\n", "13.3\t12.6\r\n", "13.3\t12.4\r\n", "14.2\t13.1\r\n", "13.0\t12.2\r\n", "13.8\t13.1\r\n",
	"13.4\t12.5\r\n", "14.5\t13.5\r\n", "14.2\t12.6\r\n", "13.2\t12.6\r\n", "13.9\t13.3\r\n", "14.7\t13.9\r\n", "14.7\t14.0\r\n", "14.0\t13.4\r\n", "13.0\t12.4\r\n", "14.4\t13.2\r\n",
	"14.6\t13.6\r\n", "14.2\t13.0\r\n", "15.6\t13.1\r\n", "13.8\t12.7\r\n", "13.8\t12.7\r\n", "12.8\t12.1\r\n", "14.1\t13.3\r\n", "14.0\t13.0\r\n", "14.4\t12.7\r\n", "13.5\t12.7\r\n",
	"12.8\t12.1\r\n", "13.3\t12.5\r\n", "12.8\t12.0\r\n", "14.3\t12.3\r\n", "13.5\t12.5\r\n", "14.8\t12.7\r\n", "12.9\t11.8\r\n", "13.2\t12.5\r\n", "12.8\t12.0\r\n", "13.4\t12.6\r\n",
	"14.0\t13.1\r\n", "13.8\t12.9\r\n", "13.5\t12.7\r\n", "13.3\t12.7\r\n", "15.1\t14.0\r\n", "14.2\t13.4\r\n", "13.6\t12.6\r\n", "13.4\t12.8\r\n", "13.0\t12.3\r\n", "13.4\t12.6\r\n",
	"13.6\t13.0\r\n", "14.7\t13.7\r\n", "13.9\t12.5\r\n", "13.8\t12.8\r\n", "13.0\t12.2\r\n", "13.9\t13.1\r\n", "13.9\t13.0\r\n", "13.6\t12.9\r\n", "13.0\t12.4\r\n", "13.6\t12.7\r\n",
	"13.1\t12.5\r\n", "13.9\t13.2\r\n", "13.2\t12.4\r\n", "14.7\t14.0\r\n", "14.4\t13.6\r\n", "13.2\t12.4\r\n", "12.9\t12.0\r\n", "13.5\t12.8\r\n", "14.0\t12.3\r\n", "13.6\t12.8\r\n",
	"13.2\t12.5\r\n", "13.9\t12.7\r\n", "12.5\t11.9\r\n", "12.9\t12.3\r\n", "14.0\t13.2\r\n", "12.8\t11.9\r\n", "12.2\t11.5\r\n", "13.2\t12.3\r\n", "13.6\t12.9\r\n", "12.5\t11.8\r\n",
	"14.1\t13.3\r\n", "14.0\t12.8\r\n", "12.7\t12.0\r\n", "13.1\t12.2\r\n", "15.8\t13.2\r\n", "13.2\t12.4\r\n", "14.2\t13.4\r\n", "13.3\t12.4\r\n", "13.3\t12.5\r\n", "12.6\t12.0\r\n",
	"13.9\t12.8\r\n", "13.5\t12.8\r\n", "13.2\t12.4\r\n", "13.6\t12.8\r\n", "13.5\t12.7\r\n", "12.3\t11.6\r\n", "13.4\t12.7\r\n", "13.3\t12.2\r\n", "12.7\t12.0\r\n", "13.8\t13.0\r\n",
	"12.6\t11.9\r\n", "13.5\t12.7\r\n", "15.4\t14.0\r\n", "13.2\t12.3\r\n", "13.4\t12.5\r\n", "13.8\t12.8\r\n", "13.1\t12.4\r\n", "12.8\t11.9\r\n", "13.8\t13.1\r\n", "13.7\t13.1\r\n",
	"13.3\t12.6\r\n", "12.8\t12.1\r\n", "14.5\t13.4\r\n", "13.2\t12.4\r\n", "12.6\t11.9\r\n", "14.8\t12.2\r\n", "14.0\t13.3\r\n", "13.6\t12.6\r\n", "13.3\t12.5\r\n", "14.2\t13.5\r\n",
	"13.3\t12.6\r\n", "14.0\t13.1\r\n", "14.1\t13.2\r\n", "13.9\t12.8\r\n", "12.5\t11.3\r\n", "12.3\t11.7\r\n", "13.0\t12.4\r\n", "13.3\t12.4\r\n", "13.8\t13.1\r\n", "12.2\t11.7\r\n",
	"13.4\t12.8\r\n", "13.6\t12.7\r\n", "13.5\t12.8\r\n", "14.0\t12.8\r\n", "13.3\t12.6\r\n", "13.0\t12.1\r\n", "14.9\t13.8\r\n", "14.0\t13.2\r\n", "14.0\t13.1\r\n", "14.8\t13.6\r\n",
	"13.2\t12.5\r\n", "13.4\t12.1\r\n", "12.8\t12.0\r\n", "14.3\t13.4\r\n", "13.8\t13.2\r\n", "12.1\t11.5\r\n", "12.7\t12.0\r\n", "15.6\t13.9\r\n", "14.0\t13.1\r\n", "13.3\t12.5\r\n",
	"14.1\t13.1\r\n", "14.7\t13.1\r\n", "13.3\t12.5\r\n", "13.9\t13.2\r\n", "14.3\t13.7\r\n", "13.8\t13.0\r\n", "14.8\t13.6\r\n", "13.8\t13.2\r\n", "13.1\t12.4\r\n", "13.6\t12.6\r\n",
	"15.0\t13.9\r\n", "13.8\t13.0\r\n", "12.7\t12.1\r\n", "13.9\t13.0\r\n", "14.6\t13.7\r\n", "13.4\t12.6\r\n", "14.7\t13.6\r\n", "14.1\t13.3\r\n", "14.0\t13.1\r\n", "13.6\t12.3\r\n",
	"14.8\t13.8\r\n", "13.2\t12.5\r\n", "16.3\t14.7\r\n", "16.3\t14.2\r\n", "14.2\t13.4\r\n", "14.2\t13.4\r\n", "14.8\t13.6\r\n", "15.6\t14.2\r\n", "14.6\t14.0\r\n", "12.7\t11.9\r\n",
	"13.7\t12.4\r\n", "14.6\t13.7\r\n", "14.1\t13.3\r\n", "14.0\t13.0\r\n", "13.7\t12.9\r\n", "14.7\t13.4\r\n", "13.7\t12.4\r\n", "13.9\t12.7\r\n", "13.3\t12.4\r\n", "13.9\t12.9\r\n",
	"13.6\t12.5\r\n", "13.4\t12.3\r\n", "13.1\t12.1\r\n", "13.2\t12.3\r\n", "15.1\t13.9\r\n", "13.9\t12.7\r\n", "13.9\t12.9\r\n", "14.6\t13.4\r\n", "13.5\t12.5\r\n", "14.3\t13.2\r\n",
	"15.0\t14.1\r\n", "14.6\t13.1\r\n", "14.0\t11.8\r\n", "15.6\t14.3\r\n", "14.1\t12.9\r\n", "13.4\t12.5\r\n", "14.0\t12.8\r\n", "11.8\t11.1\r\n", "15.6\t13.9\r\n", "13.6\t12.9\r\n",
	"13.6\t12.8\r\n", "14.7\t14.0\r\n", "13.9\t12.5\r\n", "14.6\t13.4\r\n", "13.3\t12.2\r\n", "13.8\t12.5\r\n", "13.5\t12.6\r\n", "14.1\t13.2\r\n", "13.4\t12.4\r\n", "14.0\t12.0\r\n",
	"13.7\t12.8\r\n", "13.6\t12.8\r\n", "14.4\t13.5\r\n", "13.8\t12.9\r\n", "13.5\t12.6\r\n", "13.6\t13.0\r\n", "13.5\t12.4\r\n", "13.1\t12.1\r\n", "24.3\t15.1\r\n", "14.3\t12.7\r\n",
	"14.7\t13.5\r\n", "13.5\t12.7\r\n", "14.1\t12.9\r\n", "14.2\t12.9\r\n", "14.8\t13.6\r\n", "14.1\t12.8\r\n", "14.1\t13.3\r\n", "15.4\t14.1\r\n", "14.8\t13.0\r\n", "13.8\t12.9\r\n",
	"13.8\t12.4\r\n", "13.9\t13.1\r\n", "13.3\t12.6\r\n", "13.6\t12.8\r\n", "15.2\t14.2\r\n", "14.5\t13.5\r\n", "14.4\t12.5\r\n", "15.7\t13.8\r\n", "14.6\t13.4\r\n", "16.1\t14.4\r\n",
	"15.2\t14.0\r\n", "14.1\t12.8\r\n", "14.5\t13.3\r\n", "13.8\t12.8\r\n", "15.4\t14.4\r\n", "14.0\t12.8\r\n", "14.0\t13.1\r\n", "13.4\t12.3\r\n", "13.2\t12.4\r\n", "13.6\t12.7\r\n",
	"12.8\t12.0\r\n", "14.4\t13.4\r\n", "14.2\t13.1\r\n", "13.3\t12.3\r\n", "14.9\t13.5\r\n", "13.5\t12.6\r\n", "14.4\t12.9\r\n", "13.2\t12.0\r\n", "14.5\t13.1\r\n", "15.0\t13.4\r\n",
	"14.3\t13.3\r\n", "13.9\t12.8\r\n", "15.6\t14.1\r\n", "14.4\t13.1\r\n", "14.0\t13.2\r\n", "12.8\t12.1\r\n", "15.9\t14.5\r\n", "14.4\t12.9\r\n", "14.9\t13.8\r\n", "14.5\t13.2\r\n",
	"14.6\t13.0\r\n", "14.6\t13.2\r\n", "16.0\t14.2\r\n", "14.2\t13.1\r\n", "15.8\t14.4\r\n", "13.8\t13.0\r\n", "15.3\t14.0\r\n", "13.8\t12.8\r\n", "13.6\t12.6\r\n", "13.5\t12.9\r\n",
	"14.5\t13.1\r\n", "13.4\t12.6\r\n", "14.0\t13.0\r\n", "12.4\t11.6\r\n", "15.0\t13.8\r\n", "12.9\t12.1\r\n", "17.3\t15.2\r\n", "15.0\t13.7\r\n", "15.3\t13.5\r\n", "14.2\t12.9\r\n",
	"13.8\t12.8\r\n", "15.3\t14.1\r\n", "14.2\t12.9\r\n", "13.7\t12.7\r\n", "14.5\t13.1\r\n", "12.9\t12.0\r\n", "14.2\t13.4\r\n", "14.6\t13.5\r\n", "13.2\t12.4\r\n", "15.6\t14.2\r\n",
	"13.6\t12.1\r\n", "12.3\t11.5\r\n", "13.9\t12.7\r\n", "14.3\t13.4\r\n", "15.0\t13.5\r\n", "13.7\t12.7\r\n", "14.6\t13.6\r\n", "13.9\t12.7\r\n", "17.4\t14.2\r\n", "12.9\t12.2\r\n",
	"15.0\t14.2\r\n", "12.7\t11.9\r\n", "13.9\t12.8\r\n", "12.8\t12.1\r\n", "13.4\t12.2\r\n", "13.0\t12.0\r\n", "15.4\t13.8\r\n", "14.3\t13.0\r\n", "14.3\t13.3\r\n", "14.6\t13.3\r\n",
	"13.4\t12.3\r\n", "12.9\t11.8\r\n", "13.0\t12.2\r\n", "14.7\t13.2\r\n", "14.7\t13.6\r\n", "14.8\t13.4\r\n", "13.7\t12.9\r\n", "11.9\t11.3\r\n", "13.6\t12.4\r\n", "14.2\t13.4\r\n",
	"13.8\t13.1\r\n", "13.8\t12.4\r\n", "13.8\t12.4\r\n", "13.2\t11.9\r\n", "15.7\t14.2\r\n", "15.2\t13.5\r\n", "14.3\t13.2\r\n", "16.0\t14.0\r\n", "13.9\t12.8\r\n", "14.9\t13.3\r\n",
	"15.6\t14.1\r\n", "14.3\t13.2\r\n", "13.2\t12.2\r\n", "15.4\t14.0\r\n", "13.0\t12.1\r\n", "14.6\t14.0\r\n", "14.2\t13.3\r\n", "13.9\t13.0\r\n", "15.3\t14.1\r\n", "13.9\t12.7\r\n",
	"14.1\t12.6\r\n", "13.9\t12.6\r\n", "14.0\t12.1\r\n", "12.8\t11.9\r\n", "14.7\t13.1\r\n", "15.4\t14.2\r\n", "13.2\t12.3\r\n", "13.9\t12.8\r\n", "13.2\t12.3\r\n", "13.7\t12.9\r\n",
	"14.5\t13.6\r\n", "14.9\t14.0\r\n", "12.6\t11.9\r\n", "14.1\t13.2\r\n", "14.5\t13.5\r\n", "14.4\t12.3\r\n", "13.7\t12.7\r\n", "14.4\t13.3\r\n", "14.4\t13.2\r\n", "14.5\t13.1\r\n",
	"15.1\t13.8\r\n", "12.6\t11.9\r\n", "14.5\t13.3\r\n", "12.8\t12.1\r\n", "13.1\t12.3\r\n", "13.9\t12.4\r\n", "12.8\t12.0\r\n", "12.8\t12.1\r\n", "14.8\t13.7\r\n", "13.9\t12.3\r\n",
	"13.6\t12.6\r\n", "14.5\t13.4\r\n", "13.6\t12.4\r\n", "13.8\t13.1\r\n", "13.6\t12.7\r\n", "13.3\t12.3\r\n", "12.5\t11.9\r\n", "15.5\t13.9\r\n", "13.7\t13.0\r\n", "14.2\t13.3\r\n",
	"13.5\t12.3\r\n", "14.4\t13.5\r\n", "13.1\t12.3\r\n", "13.0\t12.3\r\n", "14.2\t13.2\r\n", "13.3\t12.4\r\n", "14.0\t12.9\r\n", "14.3\t00.0\r\n", "14.4\t13.0\r\n", "13.7\t12.8\r\n",
	"14.2\t13.0\r\n", "14.4\t13.5\r\n", "13.6\t12.7\r\n", "13.2\t12.2\r\n", "13.7\t12.4\r\n", "13.8\t12.1\r\n", "14.5\t13.6\r\n", "14.4\t13.3\r\n", "13.8\t12.8\r\n", "13.6\t12.7\r\n",
	"28.0\t17.3\r\n", "13.5\t12.5\r\n", "13.7\t12.7\r\n", "14.1\t13.1\r\n", "13.9\t12.2\r\n", "12.7\t11.7\r\n", "13.2\t12.4\r\n", "12.5\t11.8\r\n", "14.5\t13.6\r\n", "13.7\t12.9\r\n",
	"13.6\t12.6\r\n", "14.2\t13.1\r\n", "15.0\t13.9\r\n", "14.0\t13.0\r\n", "12.6\t11.9\r\n", "14.4\t13.2\r\n", "15.0\t13.7\r\n", "13.2\t12.1\r\n", "14.4\t12.9\r\n", "12.9\t12.1\r\n",
	"13.5\t12.4\r\n", "13.7\t12.4\r\n", "14.8\t13.7\r\n", "14.0\t13.0\r\n", "13.2\t12.4\r\n", "13.4\t12.5\r\n", "12.9\t12.1\r\n", "14.0\t13.1\r\n", "13.6\t12.5\r\n", "13.1\t12.4\r\n",
	"12.8\t12.1\r\n", "15.9\t14.2\r\n", "14.2\t13.2\r\n", "13.6\t12.6\r\n", "15.2\t13.0\r\n", "13.4\t12.4\r\n", "13.2\t11.9\r\n", "13.7\t12.6\r\n", "13.6\t12.2\r\n", "14.5\t13.5\r\n",
	"14.4\t13.3\r\n", "13.1\t12.6\r\n", "12.6\t11.5\r\n", "13.0\t12.1\r\n", "12.8\t12.0\r\n", "12.5\t11.9\r\n", "15.5\t14.2\r\n", "14.1\t13.1\r\n", "13.0\t12.1\r\n", "14.7\t13.5\r\n",
	"13.7\t12.6\r\n", "14.2\t13.0\r\n", "15.6\t14.2\r\n", "14.0\t12.8\r\n", "12.8\t12.0\r\n", "14.8\t13.7\r\n", "13.0\t12.3\r\n", "13.8\t12.9\r\n", "12.7\t11.9\r\n", "14.1\t12.7\r\n",
	"13.2\t12.3\r\n", "15.7\t14.5\r\n", "13.7\t13.0\r\n", "12.4\t11.8\r\n", "14.0\t12.8\r\n", "14.9\t13.6\r\n", "12.9\t11.8\r\n", "14.3\t13.3\r\n", "13.7\t12.8\r\n", "14.4\t13.4\r\n",
	"13.2\t12.2\r\n", "13.4\t12.5\r\n", "12.6\t11.8\r\n", "12.8\t12.0\r\n", "12.9\t11.8\r\n", "12.1\t11.3\r\n", "12.2\t11.5\r\n", "12.7\t12.0\r\n", "12.2\t11.3\r\n", "13.4\t11.8\r\n",
	"13.3\t12.5\r\n", "12.9\t12.3\r\n", "13.2\t12.4\r\n", "28.0\t15.4\r\n", "14.2\t13.2\r\n", "15.2\t13.9\r\n", "15.9\t14.7\r\n", "13.6\t12.7\r\n", "13.9\t12.7\r\n", "14.6\t13.3\r\n",
	"14.4\t13.2\r\n", "14.5\t13.3\r\n", "14.8\t14.0\r\n", "13.0\t12.1\r\n", "15.6\t13.9\r\n", "12.6\t11.9\r\n", "12.7\t12.0\r\n", "13.9\t12.9\r\n", "14.2\t13.2\r\n", "13.7\t12.6\r\n",
	"13.6\t12.3\r\n", "13.8\t12.7\r\n", "13.6\t12.4\r\n", "13.0\t12.2\r\n", "13.8\t12.7\r\n", "13.8\t12.9\r\n", "13.9\t13.0\r\n", "13.5\t12.5\r\n", "13.0\t12.2\r\n", "13.6\t12.7\r\n",
	"13.3\t12.7\r\n", "13.3\t12.3\r\n", "13.4\t12.4\r\n", "15.0\t13.9\r\n", "13.5\t12.0\r\n", "15.3\t13.8\r\n", "13.4\t12.6\r\n", "13.7\t12.8\r\n", "13.6\t12.5\r\n", "28.0\t14.9\r\n",
	"14.0\t12.9\r\n", "13.3\t12.5\r\n", "13.6\t12.7\r\n", "13.6\t12.6\r\n", "13.7\t13.0\r\n", "13.7\t12.9\r\n", "13.3\t12.6\r\n", "12.8\t12.2\r\n", "14.6\t13.3\r\n", "14.0\t13.1\r\n",
	"14.2\t13.2\r\n", "15.2\t14.2\r\n", "13.8\t12.9\r\n", "12.5\t11.7\r\n", "14.0\t12.9\r\n", "15.2\t13.9\r\n", "12.8\t12.0\r\n", "13.4\t12.4\r\n", "12.4\t11.8\r\n", "13.3\t12.5\r\n",
	"13.2\t12.4\r\n", "13.9\t13.0\r\n", "13.4\t12.5\r\n", "13.6\t12.8\r\n", "13.9\t12.9\r\n", "14.0\t12.9\r\n", "14.0\t13.2\r\n", "16.5\t14.3\r\n", "12.9\t11.9\r\n", "13.8\t12.2\r\n",
	"13.4\t12.6\r\n", "13.2\t12.1\r\n", "13.5\t12.6\r\n", "12.6\t11.8\r\n", "13.6\t12.7\r\n", "14.7\t13.7\r\n", "14.7\t13.5\r\n", "13.6\t12.7\r\n", "13.1\t12.3\r\n", "12.2\t11.5\r\n",
	"14.7\t13.7\r\n", "14.6\t13.5\r\n", "13.8\t12.8\r\n", "13.4\t12.5\r\n", "14.1\t12.8\r\n", "15.5\t14.3\r\n", "13.7\t12.8\r\n", "14.6\t13.6\r\n", "13.4\t12.6\r\n", "13.9\t13.0\r\n",
	"13.4\t12.5\r\n", "13.5\t12.7\r\n", "13.8\t12.8\r\n", "14.1\t13.2\r\n", "13.8\t12.8\r\n", "13.3\t12.2\r\n", "13.4\t12.4\r\n", "14.5\t13.1\r\n", "14.6\t13.2\r\n", "15.0\t14.0\r\n",
	"15.0\t13.8\r\n", "13.8\t12.6\r\n", "13.9\t13.0\r\n", "12.8\t12.2\r\n", "15.2\t13.8\r\n", "13.2\t12.5\r\n", "15.4\t13.6\r\n", "13.5\t12.7\r\n", "12.9\t12.1\r\n", "13.8\t12.9\r\n",
	"13.5\t12.8\r\n", "12.8\t11.8\r\n", "15.0\t13.6\r\n", "13.6\t12.2\r\n", "15.5\t14.1\r\n", "13.1\t11.9\r\n", "13.7\t12.1\r\n", "15.1\t13.7\r\n", "14.7\t13.7\r\n", "14.8\t13.2\r\n",
	"13.9\t12.9\r\n", "14.6\t13.4\r\n", "14.7\t13.4\r\n", "13.8\t13.0\r\n", "14.3\t13.2\r\n", "14.3\t13.5\r\n", "13.6\t12.6\r\n", "12.9\t12.0\r\n", "12.7\t12.0\r\n", "13.8\t12.7\r\n",
	"14.7\t13.6\r\n", "14.0\t12.8\r\n", "13.9\t12.8\r\n", "13.1\t12.2\r\n", "13.8\t12.7\r\n", "14.9\t13.7\r\n", "12.7\t11.9\r\n", "13.3\t12.4\r\n", "12.9\t12.1\r\n", "13.4\t12.7\r\n",
	"13.0\t12.1\r\n", "13.6\t12.5\r\n", "14.6\t12.6\r\n", "14.4\t13.1\r\n", "13.9\t12.7\r\n", "14.4\t13.5\r\n", "14.4\t12.8\r\n", "13.5\t12.8\r\n", "14.2\t12.8\r\n", "13.6\t12.5\r\n",
	"14.2\t13.1\r\n", "12.9\t12.0\r\n", "15.0\t13.6\r\n", "12.8\t12.0\r\n", "13.9\t12.4\r\n", "14.1\t13.0\r\n", "15.0\t14.0\r\n", "13.1\t12.3\r\n", "12.9\t11.9\r\n", "13.9\t12.9\r\n",
	"15.8\t13.8\r\n", "13.8\t12.2\r\n", "13.4\t12.3\r\n", "13.7\t12.5\r\n", "14.4\t12.9\r\n", "12.7\t11.9\r\n", "12.9\t12.1\r\n", "13.4\t12.1\r\n", "14.2\t13.0\r\n", "14.2\t13.2\r\n",
	"14.5\t13.4\r\n", "13.4\t12.4\r\n", "13.5\t12.5\r\n", "13.6\t12.7\r\n", "14.4\t12.9\r\n", "13.2\t11.9\r\n", "13.5\t12.5\r\n", "13.8\t12.8\r\n", "15.1\t13.8\r\n", "14.0\t13.1\r\n",
	"14.4\t13.5\r\n", "13.8\t12.7\r\n", "12.8\t12.0\r\n", "14.0\t13.1\r\n", "13.1\t12.4\r\n", "14.8\t13.2\r\n", "12.8\t11.9\r\n", "13.5\t12.7\r\n", "13.5\t12.6\r\n", "13.7\t13.0\r\n",
	"13.9\t13.0\r\n", "13.3\t12.5\r\n", "12.8\t12.0\r\n", "14.0\t12.7\r\n", "13.4\t12.2\r\n", "13.6\t12.6\r\n", "13.9\t12.6\r\n", "12.1\t11.4\r\n", "14.7\t13.6\r\n", "13.7\t12.8\r\n",
	"14.5\t13.4\r\n", "14.0\t12.5\r\n", "13.9\t13.1\r\n", "13.5\t12.8\r\n", "13.8\t12.8\r\n", "14.1\t13.2\r\n", "14.4\t13.4\r\n", "13.0\t12.4\r\n", "13.4\t12.4\r\n", "14.6\t13.5\r\n",
	"13.2\t12.3\r\n", "13.0\t12.1\r\n", "14.0\t13.1\r\n", "12.3\t11.3\r\n", "15.0\t13.9\r\n", "13.5\t12.5\r\n", "14.1\t13.1\r\n", "13.4\t12.4\r\n", "14.4\t13.2\r\n", "13.6\t12.9\r\n",
	"15.4\t14.4\r\n", "13.3\t12.5\r\n", "13.4\t12.5\r\n", "14.2\t13.4\r\n", "12.7\t11.8\r\n", "13.6\t12.7\r\n", "14.0\t13.2\r\n", "17.0\t13.6\r\n", "12.8\t11.9\r\n", "13.5\t12.7\r\n",
	"13.0\t12.3\r\n", "13.6\t12.7\r\n", "12.3\t11.6\r\n", "14.2\t13.2\r\n", "13.5\t12.6\r\n", "13.3\t12.7\r\n", "13.9\t12.7\r\n", "14.0\t13.2\r\n", "14.1\t12.9\r\n", "14.4\t13.3\r\n",
	"15.0\t13.8\r\n", "12.6\t11.7\r\n", "12.2\t11.4\r\n", "13.7\t12.4\r\n", "13.8\t13.0\r\n", "14.6\t13.6\r\n", "13.6\t12.9\r\n", "12.5\t11.5\r\n", "13.4\t12.4\r\n", "15.0\t13.8\r\n",
	"14.2\t12.9\r\n", "13.2\t12.7\r\n", "13.5\t12.6\r\n", "13.3\t12.3\r\n", "13.4\t12.4\r\n", "14.1\t12.7\r\n", "13.3\t12.4\r\n", "13.3\t12.5\r\n", "13.6\t12.6\r\n", "13.0\t12.1\r\n",
	"14.9\t13.5\r\n", "13.8\t13.0\r\n", "13.2\t12.5\r\n", "15.1\t14.1\r\n", "14.0\t12.5\r\n", "12.8\t12.1\r\n", "13.9\t13.1\r\n", "13.3\t12.6\r\n", "13.3\t12.7\r\n", "14.7\t13.6\r\n",
	"13.2\t12.3\r\n", "11.9\t11.5\r\n", "12.4\t11.6\r\n", "14.3\t13.4\r\n", "12.1\t11.2\r\n", "13.0\t12.0\r\n", "14.1\t13.2\r\n", "13.9\t12.9\r\n", "12.6\t11.8\r\n", "13.5\t12.8\r\n",
	"14.2\t13.3\r\n", "14.9\t13.8\r\n", "12.4\t11.7\r\n", "11.7\t10.8\r\n", "13.8\t12.4\r\n", "12.6\t12.0\r\n", "14.0\t12.6\r\n", "14.2\t13.1\r\n", "13.7\t12.8\r\n", "13.6\t12.5\r\n",
	"14.2\t13.0\r\n", "14.2\t13.4\r\n", "13.7\t12.8\r\n", "14.1\t12.7\r\n", "14.1\t13.2\r\n", "14.5\t13.2\r\n", "14.1\t13.2\r\n", "12.0\t11.5\r\n", "12.9\t12.2\r\n", "12.6\t11.7\r\n",
	"13.6\t12.6\r\n", "13.3\t11.8\r\n", "12.8\t12.2\r\n", "13.5\t12.8\r\n", "14.3\t13.5\r\n", "13.2\t12.1\r\n", "14.8\t13.8\r\n", "13.0\t11.9\r\n", "13.2\t11.9\r\n", "13.3\t12.5\r\n",
	"13.8\t12.9\r\n", "14.2\t12.7\r\n", "12.8\t12.0\r\n", "13.1\t12.5\r\n", "14.9\t13.7\r\n", "13.0\t11.8\r\n", "13.9\t12.9\r\n", "14.1\t13.4\r\n", "13.8\t12.9\r\n", "12.8\t11.8\r\n",
	"13.9\t12.9\r\n", "13.1\t12.3\r\n", "14.1\t12.9\r\n", "14.0\t13.0\r\n", "12.8\t12.0\r\n", "13.9\t13.1\r\n", "13.8\t12.7\r\n", "14.6\t13.5\r\n", "13.2\t12.4\r\n", "13.9\t12.9\r\n",
	"13.2\t12.4\r\n", "13.2\t12.4\r\n", "13.5\t12.3\r\n", "14.5\t13.4\r\n", "13.6\t12.1\r\n", "13.1\t12.0\r\n", "13.8\t12.3\r\n", "13.3\t12.3\r\n", "12.7\t11.9\r\n", "13.2\t12.2\r\n",
	"12.8\t11.7\r\n", "13.3\t12.5\r\n", "14.2\t13.2\r\n", "12.3\t11.8\r\n", "13.8\t12.9\r\n", "13.1\t12.4\r\n", "13.1\t12.4\r\n", "13.9\t13.1\r\n", "12.5\t11.9\r\n", "13.0\t12.2\r\n",
	"13.0\t12.3\r\n", "12.3\t11.4\r\n", "13.9\t12.6\r\n", "13.5\t12.6\r\n", "13.1\t12.3\r\n", "14.8\t13.4\r\n", "14.1\t13.0\r\n", "13.9\t12.9\r\n", "14.8\t12.7\r\n", "13.4\t12.5\r\n",
	"13.4\t12.5\r\n", "14.9\t13.9\r\n", "14.1\t13.0\r\n", "13.0\t12.2\r\n", "12.3\t11.4\r\n", "13.8\t13.1\r\n", "14.4\t13.5\r\n", "13.7\t12.8\r\n", "13.3\t12.4\r\n", "13.2\t12.3\r\n",
	"14.4\t13.2\r\n", "15.5\t14.4\r\n", "13.2\t12.4\r\n", "14.0\t13.0\r\n", "13.9\t12.5\r\n", "14.2\t13.4\r\n", "14.3\t13.7\r\n", "14.8\t14.0\r\n", "13.9\t12.9\r\n", "13.4\t12.6\r\n",
	"13.2\t12.5\r\n", "12.9\t12.3\r\n", "15.1\t13.1\r\n", "13.6\t12.6\r\n", "14.3\t13.0\r\n", "12.6\t11.8\r\n", "14.3\t13.4\r\n", "15.0\t13.6\r\n", "14.2\t12.7\r\n", "14.4\t13.4\r\n",
	"12.9\t12.0\r\n", "13.5\t12.8\r\n", "13.6\t12.9\r\n", "13.3\t12.7\r\n", "13.1\t12.3\r\n", "13.2\t12.6\r\n", "12.4\t11.8\r\n", "12.3\t11.7\r\n", "15.3\t13.6\r\n", "14.0\t12.9\r\n",
	"13.2\t12.3\r\n", "13.9\t12.9\r\n", "12.8\t11.9\r\n", "14.1\t12.0\r\n", "14.1\t13.1\r\n", "14.2\t13.3\r\n", "14.6\t13.6\r\n", "13.2\t12.1\r\n", "13.0\t12.4\r\n", "14.3\t13.4\r\n",
	"14.3\t13.6\r\n", "14.5\t13.0\r\n", "13.6\t13.0\r\n", "14.6\t13.8\r\n", "13.0\t12.2\r\n", "14.0\t12.8\r\n", "13.6\t12.8\r\n", "13.2\t12.4\r\n", "13.8\t12.8\r\n", "13.9\t12.9\r\n",
	"14.3\t13.2\r\n", "13.8\t12.8\r\n", "13.2\t12.4\r\n", "13.9\t12.9\r\n", "13.0\t12.3\r\n", "15.7\t14.7\r\n", "14.6\t13.9\r\n", "13.7\t12.5\r\n", "13.9\t13.3\r\n", "13.4\t12.4\r\n",
	"14.1\t12.5\r\n", "13.1\t12.2\r\n", "14.9\t13.8\r\n", "13.1\t12.4\r\n", "14.0\t13.2\r\n", "13.8\t13.0\r\n", "13.3\t12.4\r\n", "12.9\t12.3\r\n", "13.8\t12.9\r\n", "13.2\t12.1\r\n",
	"12.9\t12.2\r\n", "13.2\t12.1\r\n", "13.2\t12.6\r\n", "13.1\t12.4\r\n", "13.6\t12.7\r\n", "12.3\t11.7\r\n", "12.9\t12.2\r\n", "12.8\t12.3\r\n", "12.3\t11.7\r\n", "13.2\t12.5\r\n",
	"12.8\t12.0\r\n", "13.5\t12.7\r\n", "13.4\t12.6\r\n", "13.0\t12.0\r\n", "13.4\t12.4\r\n", "13.2\t12.5\r\n", "13.4\t12.7\r\n", "13.9\t12.6\r\n", "14.0\t13.2\r\n", "13.8\t12.8\r\n",
	"13.0\t12.2\r\n", "14.4\t13.7\r\n", "13.9\t12.8\r\n", "12.6\t11.9\r\n", "12.6\t11.9\r\n", "13.4\t12.5\r\n", "15.0\t13.9\r\n", "12.7\t11.8\r\n", "14.6\t13.3\r\n", "14.2\t13.3\r\n",
	"13.0\t11.9\r\n", "13.6\t12.7\r\n", "14.6\t13.8\r\n", "15.2\t14.2\r\n", "14.0\t13.1\r\n", "14.1\t12.8\r\n", "14.0\t12.9\r\n", "15.2\t13.4\r\n", "18.4\t15.2\r\n", "13.4\t12.8\r\n",
	"14.2\t13.5\r\n", "14.0\t13.2\r\n", "13.4\t12.6\r\n", "13.8\t13.1\r\n", "13.4\t12.9\r\n", "13.9\t13.0\r\n", "14.4\t13.6\r\n", "15.7\t14.3\r\n", "14.9\t13.6\r\n", "13.0\t12.3\r\n",
	"13.1\t12.4\r\n", "12.5\t11.7\r\n", "14.4\t12.4\r\n", "14.6\t13.0\r\n", "14.8\t13.2\r\n", "14.3\t13.5\r\n", "13.7\t13.0\r\n", "13.9\t13.0\r\n", "12.5\t11.7\r\n", "14.4\t13.7\r\n",
	"14.2\t13.3\r\n", "14.0\t13.1\r\n", "14.9\t13.6\r\n", "14.0\t13.2\r\n", "13.8\t12.9\r\n", "13.4\t12.6\r\n", "15.6\t14.3\r\n", "14.4\t13.7\r\n", "12.8\t11.9\r\n", "13.8\t13.0\r\n",
	"14.5\t13.6\r\n", "14.7\t13.7\r\n", "13.8\t12.7\r\n", "14.0\t13.0\r\n", "15.7\t13.8\r\n", "13.1\t12.3\r\n", "15.4\t13.5\r\n", "16.4\t14.1\r\n", "13.8\t12.7\r\n", "15.5\t14.3\r\n",
	"15.1\t13.9\r\n", "13.9\t12.9\r\n", "14.2\t13.4\r\n", "14.6\t13.4\r\n", "13.8\t12.9\r\n", "16.7\t15.0\r\n", "16.5\t15.5\r\n", "16.3\t15.0\r\n", "13.6\t13.0\r\n", "16.6\t15.1\r\n",
	"14.3\t12.6\r\n", "14.6\t13.0\r\n", "15.4\t14.1\r\n", "15.5\t14.5\r\n", "13.6\t12.6\r\n", "14.5\t13.0\r\n", "15.6\t14.3\r\n", "13.7\t12.3\r\n", "14.2\t12.9\r\n", "15.2\t14.1\r\n",
	"13.1\t12.1\r\n", "13.6\t12.7\r\n", "13.8\t12.9\r\n", "17.2\t13.9\r\n", "14.6\t14.0\r\n", "15.1\t13.7\r\n", "13.8\t12.8\r\n", "15.2\t13.7\r\n", "15.1\t13.6\r\n", "15.4\t13.9\r\n",
	"13.2\t12.2\r\n", "14.0\t12.8\r\n", "13.9\t12.8\r\n", "13.2\t12.1\r\n", "13.8\t12.7\r\n", "14.4\t13.7\r\n", "14.6\t13.6\r\n", "14.0\t13.0\r\n", "13.6\t12.9\r\n", "14.6\t13.1\r\n",
	"14.8\t13.6\r\n", "15.8\t14.3\r\n", "14.6\t13.0\r\n", "14.2\t12.6\r\n", "15.2\t13.8\r\n", "15.2\t14.2\r\n", "14.3\t13.4\r\n", "15.0\t13.9\r\n", "15.4\t13.8\r\n", "12.5\t11.7\r\n",
	"12.9\t12.1\r\n", "13.5\t12.8\r\n", "13.4\t12.6\r\n", "14.8\t13.8\r\n", "14.2\t13.5\r\n", "14.1\t13.2\r\n", "14.6\t13.2\r\n", "14.5\t13.2\r\n", "16.0\t13.8\r\n", "16.6\t14.2\r\n",
	"14.0\t13.0\r\n", "14.3\t13.0\r\n", "14.0\t13.1\r\n", "13.6\t12.1\r\n", "14.6\t13.7\r\n", "13.1\t12.4\r\n", "14.2\t13.6\r\n", "14.2\t13.4\r\n", "14.0\t12.9\r\n", "13.5\t12.9\r\n",
	"14.6\t13.9\r\n", "13.2\t11.8\r\n", "14.1\t13.1\r\n", "16.1\t14.3\r\n", "15.4\t13.8\r\n", "13.6\t12.5\r\n", "15.7\t14.1\r\n", "14.9\t13.5\r\n", "14.2\t12.8\r\n", "14.3\t12.9\r\n",
	"14.2\t13.1\r\n", "14.8\t13.3\r\n", "14.8\t13.2\r\n", "13.3\t12.6\r\n", "13.9\t13.1\r\n", "14.2\t13.0\r\n", "13.9\t12.4\r\n", "13.1\t12.6\r\n", "14.0\t12.9\r\n", "14.0\t13.0\r\n",
	"14.3\t13.3\r\n", "14.0\t12.9\r\n", "14.9\t13.6\r\n", "15.3\t13.8\r\n", "16.0\t14.9\r\n", "15.2\t13.5\r\n", "15.0\t14.1\r\n", "13.6\t12.7\r\n", "13.7\t13.0\r\n", "13.4\t12.6\r\n",
	"13.7\t12.3\r\n", "15.3\t13.7\r\n", "13.6\t12.9\r\n", "13.7\t12.9\r\n", "15.7\t14.4\r\n", "13.5\t12.6\r\n", "14.4\t13.3\r\n", "14.9\t13.3\r\n", "14.9\t13.7\r\n", "14.6\t13.4\r\n",
	"16.0\t14.8\r\n", "13.9\t12.7\r\n", "13.9\t12.8\r\n", "13.7\t12.7\r\n", "13.4\t12.8\r\n", "13.3\t12.6\r\n", "13.8\t13.1\r\n", "13.2\t12.5\r\n", "13.4\t12.7\r\n", "13.3\t12.6\r\n",
	"15.0\t13.8\r\n", "14.5\t12.7\r\n", "19.4\t14.3\r\n", "13.5\t12.5\r\n", "14.6\t13.6\r\n", "13.6\t12.5\r\n", "14.0\t13.1\r\n", "13.9\t12.7\r\n", "13.3\t12.4\r\n", "17.4\t13.9\r\n",
	"13.4\t12.5\r\n", "12.6\t12.0\r\n", "14.1\t13.3\r\n", "12.8\t12.2\r\n", "13.4\t12.6\r\n", "12.9\t12.2\r\n", "14.2\t13.3\r\n", "13.9\t12.7\r\n", "14.1\t12.8\r\n", "13.5\t12.5\r\n",
	"13.4\t12.5\r\n", "13.1\t12.2\r\n", "13.8\t12.7\r\n", "13.2\t12.4\r\n", "15.4\t14.0\r\n", "14.3\t12.7\r\n", "12.8\t12.1\r\n", "13.2\t12.4\r\n", "13.2\t12.5\r\n", "14.8\t13.8\r\n",
	"13.5\t12.6\r\n", "13.0\t12.3\r\n", "14.7\t13.8\r\n", "14.4\t13.4\r\n", "13.5\t12.6\r\n", "13.6\t12.7\r\n", "12.9\t12.0\r\n", "14.7\t13.1\r\n", "13.4\t12.5\r\n", "13.7\t12.7\r\n",
	"18.7\t13.3\r\n", "13.3\t12.4\r\n", "13.3\t12.6\r\n", "13.8\t12.8\r\n", "15.6\t14.4\r\n", "14.3\t13.4\r\n", "13.9\t12.9\r\n", "13.4\t12.6\r\n", "13.7\t12.9\r\n", "14.2\t13.4\r\n",
	"14.3\t13.2\r\n", "14.4\t13.4\r\n", "14.2\t13.1\r\n", "14.2\t13.1\r\n", "14.6\t13.2\r\n", "13.9\t13.0\r\n", "14.1\t13.2\r\n", "14.0\t12.8\r\n", "13.2\t12.3\r\n", "13.2\t12.6\r\n",
	"14.3\t13.6\r\n", "13.1\t12.3\r\n", "13.9\t13.1\r\n", "13.9\t13.2\r\n", "13.0\t12.0\r\n", "14.6\t13.4\r\n", "13.3\t12.5\r\n", "13.9\t12.9\r\n", "15.6\t14.4\r\n", "14.8\t13.7\r\n",
	"12.9\t12.1\r\n", "14.7\t13.1\r\n", "14.9\t12.7\r\n", "14.7\t13.6\r\n", "14.6\t13.8\r\n", "12.4\t11.7\r\n", "13.8\t12.8\r\n", "13.3\t12.5\r\n", "13.7\t12.9\r\n", "12.9\t11.9\r\n",
	"15.9\t14.5\r\n", "14.1\t13.2\r\n", "15.0\t14.0\r\n", "14.8\t13.7\r\n", "14.6\t13.5\r\n", "14.0\t12.9\r\n", "21.9\t13.5\r\n", "12.9\t12.2\r\n", "14.2\t13.4\r\n", "13.4\t12.7\r\n",
	"13.5\t12.4\r\n", "14.8\t13.8\r\n", "13.7\t12.8\r\n", "13.0\t12.3\r\n", "14.1\t13.2\r\n", "14.4\t13.6\r\n", "14.4\t13.1\r\n", "13.0\t12.3\r\n", "14.9\t13.8\r\n", "14.0\t13.2\r\n",
	"14.6\t12.5\r\n", "16.2\t14.8\r\n", "14.6\t13.8\r\n", "14.0\t12.9\r\n", "13.4\t12.6\r\n", "14.3\t13.5\r\n", "12.9\t12.3\r\n", "13.1\t12.6\r\n", "13.6\t12.9\r\n", "15.2\t14.0\r\n",
	"13.6\t12.4\r\n", "14.1\t13.1\r\n", "28.0\t15.1\r\n", "13.3\t12.6\r\n", "13.1\t12.2\r\n", "15.1\t13.8\r\n", "14.1\t13.1\r\n", "14.0\t13.1\r\n", "13.9\t12.4\r\n", "14.5\t13.7\r\n",
	"13.4\t12.4\r\n", "16.1\t14.4\r\n", "13.4\t12.7\r\n", "13.6\t12.7\r\n", "14.2\t13.2\r\n", "14.8\t13.4\r\n", "13.6\t12.1\r\n", "14.6\t13.9\r\n", "13.8\t12.8\r\n", "13.7\t13.0\r\n",
	"14.5\t13.1\r\n", "14.3\t13.0\r\n", "13.2\t12.3\r\n", "13.6\t12.4\r\n", "14.4\t13.3\r\n", "12.5\t11.7\r\n", "13.2\t12.3\r\n", "14.6\t13.6\r\n", "13.6\t12.8\r\n", "13.6\t12.9\r\n",
	"13.9\t13.2\r\n", "16.1\t15.1\r\n", "13.7\t12.8\r\n", "12.7\t12.1\r\n", "13.0\t12.3\r\n", "13.8\t13.0\r\n", "14.2\t12.9\r\n", "12.9\t12.2\r\n", "14.7\t13.6\r\n", "12.6\t11.9\r\n",
	"14.1\t12.9\r\n", "13.8\t13.0\r\n", "14.8\t13.3\r\n", "13.0\t12.2\r\n", "14.4\t13.5\r\n", "13.4\t12.6\r\n", "13.7\t13.0\r\n", "15.4\t14.5\r\n", "15.4\t14.6\r\n", "13.2\t12.4\r\n",
	"14.2\t13.0\r\n", "13.1\t12.6\r\n", "14.1\t12.6\r\n", "13.0\t12.2\r\n", "13.5\t12.7\r\n", "14.2\t13.1\r\n", "15.7\t13.8\r\n", "13.4\t12.6\r\n", "13.4\t12.6\r\n", "14.1\t13.3\r\n",
	"22.1\t14.4\r\n", "13.2\t12.4\r\n", "14.5\t13.7\r\n", "13.0\t12.4\r\n", "13.2\t12.7\r\n", "24.0\t16.5\r\n", "15.3\t14.6\r\n", "14.5\t13.3\r\n", "13.0\t12.1\r\n", "13.8\t13.0\r\n",
	"14.4\t13.3\r\n", "13.4\t12.3\r\n", "13.1\t12.0\r\n", "13.9\t12.9\r\n", "12.9\t12.1\r\n", "13.4\t12.6\r\n", "12.7\t11.9\r\n", "13.4\t12.8\r\n", "13.6\t13.0\r\n", "13.9\t13.2\r\n",
	"13.4\t12.3\r\n", "14.5\t13.9\r\n", "13.3\t12.7\r\n", "13.0\t12.3\r\n", "15.1\t13.5\r\n", "12.5\t11.8\r\n", "13.8\t12.6\r\n", "13.6\t12.8\r\n", "13.1\t12.3\r\n", "16.7\t14.9\r\n",
	"14.5\t13.4\r\n", "13.7\t13.0\r\n", "13.6\t12.9\r\n", "13.3\t12.6\r\n", "14.1\t13.6\r\n", "12.6\t12.0\r\n", "12.8\t12.1\r\n", "13.8\t13.0\r\n", "12.5\t11.8\r\n", "14.1\t13.0\r\n",
	"13.5\t12.3\r\n", "13.6\t12.9\r\n", "14.5\t13.0\r\n", "13.2\t12.4\r\n", "13.5\t12.8\r\n", "14.4\t13.3\r\n", "13.0\t12.2\r\n", "15.0\t13.9\r\n", "14.2\t13.4\r\n", "15.9\t14.0\r\n",
	"13.3\t12.6\r\n", "14.2\t13.4\r\n", "13.9\t13.3\r\n", "13.0\t12.1\r\n", "13.4\t12.3\r\n", "14.1\t13.1\r\n", "15.6\t14.5\r\n", "14.6\t13.0\r\n", "13.8\t12.8\r\n", "14.6\t13.9\r\n",
	"12.7\t11.7\r\n", "16.9\t15.7\r\n", "14.2\t13.1\r\n", "14.8\t13.5\r\n", "14.4\t13.5\r\n", "13.5\t12.4\r\n", "13.9\t12.7\r\n", "14.0\t13.3\r\n", "12.4\t11.8\r\n", "13.1\t12.4\r\n",
	"13.1\t12.2\r\n", "13.3\t12.4\r\n", "13.2\t12.4\r\n", "14.6\t14.0\r\n", "13.0\t12.2\r\n", "13.8\t12.8\r\n", "13.6\t12.7\r\n", "13.4\t12.5\r\n", "14.8\t13.7\r\n", "15.2\t13.9\r\n",
	"14.4\t13.5\r\n", "14.0\t13.1\r\n", "14.8\t13.8\r\n", "13.4\t12.6\r\n", "13.9\t13.3\r\n", "13.8\t13.0\r\n", "13.7\t12.9\r\n", "14.2\t13.4\r\n", "14.7\t13.9\r\n", "13.0\t12.3\r\n",
	"14.4\t13.5\r\n", "14.2\t13.2\r\n", "12.9\t12.1\r\n", "14.1\t13.2\r\n", "15.6\t13.8\r\n", "14.2\t13.2\r\n", "14.1\t13.0\r\n", "13.9\t13.0\r\n", "13.7\t12.9\r\n", "14.1\t13.1\r\n",
	"16.1\t13.8\r\n", "13.6\t12.8\r\n", "12.5\t11.9\r\n", "13.4\t12.8\r\n", "13.4\t12.7\r\n", "13.6\t12.7\r\n", "13.7\t12.7\r\n", "14.0\t12.7\r\n", "13.2\t12.2\r\n", "15.3\t14.1\r\n",
	"13.5\t12.3\r\n", "13.5\t12.7\r\n", "13.3\t12.4\r\n", "13.6\t12.6\r\n", "13.4\t12.4\r\n", "13.6\t12.9\r\n", "13.3\t12.6\r\n", "13.1\t12.4\r\n", "13.6\t12.8\r\n", "13.2\t12.5\r\n",
	"13.5\t12.9\r\n", "13.4\t12.6\r\n", "14.6\t13.7\r\n", "13.9\t13.0\r\n", "14.0\t13.0\r\n", "14.8\t13.8\r\n", "12.9\t12.0\r\n", "13.5\t12.6\r\n", "16.0\t14.4\r\n", "13.1\t12.2\r\n",
	"14.2\t13.0\r\n", "13.8\t12.9\r\n", "13.9\t12.9\r\n", "13.6\t12.9\r\n", "13.1\t12.0\r\n", "13.3\t12.7\r\n", "13.4\t12.6\r\n", "12.9\t12.2\r\n", "13.8\t12.9\r\n", "14.1\t13.1\r\n",
	"15.8\t14.5\r\n", "14.3\t13.0\r\n", "13.6\t12.7\r\n", "23.7\t13.8\r\n", "13.6\t12.5\r\n", "13.3\t12.5\r\n", "15.0\t14.0\r\n", "13.6\t12.9\r\n", "13.9\t13.2\r\n", "13.7\t12.9\r\n",
	"13.9\t13.3\r\n", "13.9\t13.1\r\n", "15.0\t13.6\r\n", "13.6\t13.0\r\n", "13.4\t12.5\r\n", "13.7\t12.7\r\n", "14.4\t13.3\r\n", "14.6\t13.6\r\n", "14.3\t13.0\r\n", "13.8\t13.0\r\n",
	"15.4\t12.6\r\n", "14.0\t13.2\r\n", "14.1\t13.3\r\n", "14.6\t13.9\r\n", "13.7\t13.0\r\n", "14.1\t13.3\r\n", "13.6\t12.9\r\n", "13.2\t12.0\r\n", "13.9\t13.2\r\n", "13.2\t12.5\r\n",
	"28.0\t14.9\r\n", "14.4\t13.2\r\n", "14.2\t13.3\r\n", "16.0\t14.6\r\n", "14.3\t13.5\r\n", "13.3\t12.4\r\n", "12.8\t12.0\r\n", "13.6\t12.9\r\n", "14.0\t13.2\r\n", "14.7\t13.5\r\n",
	"13.7\t12.9\r\n", "14.1\t13.3\r\n", "13.9\t13.1\r\n", "13.6\t12.8\r\n", "13.6\t13.0\r\n", "13.4\t12.5\r\n", "14.1\t13.4\r\n", "18.4\t14.7\r\n", "13.9\t12.6\r\n", "13.8\t12.7\r\n",
	"13.6\t12.7\r\n", "14.6\t13.6\r\n", "13.1\t12.3\r\n", "14.4\t13.4\r\n", "13.6\t12.7\r\n", "13.4\t12.4\r\n", "13.0\t12.2\r\n", "14.7\t13.6\r\n", "13.4\t12.4\r\n", "13.9\t12.7\r\n",
	"13.5\t12.9\r\n", "14.0\t13.2\r\n", "16.1\t14.3\r\n", "12.8\t11.9\r\n", "15.4\t13.7\r\n", "13.0\t12.0\r\n", "14.4\t13.1\r\n", "13.3\t12.2\r\n", "13.4\t12.2\r\n", "13.4\t12.6\r\n",
	"13.7\t12.8\r\n", "13.7\t12.9\r\n", "14.1\t13.2\r\n", "13.2\t12.2\r\n", "13.8\t13.0\r\n", "13.6\t13.0\r\n", "14.4\t13.6\r\n", "12.4\t11.5\r\n", "13.3\t12.6\r\n", "12.9\t12.1\r\n",
	"14.2\t13.0\r\n", "14.3\t13.4\r\n", "13.5\t12.6\r\n", "14.7\t13.7\r\n", "14.2\t13.2\r\n", "14.4\t13.3\r\n", "13.8\t13.0\r\n", "14.0\t13.0\r\n", "14.2\t13.5\r\n", "13.5\t12.6\r\n",
	"13.7\t12.6\r\n", "13.8\t13.2\r\n", "13.0\t12.4\r\n", "13.4\t12.6\r\n", "12.8\t12.2\r\n", "14.4\t13.3\r\n", "14.0\t12.6\r\n", "12.7\t11.9\r\n", "15.2\t14.2\r\n", "14.2\t13.1\r\n",
	"13.7\t12.2\r\n", "14.0\t13.2\r\n", "14.4\t13.5\r\n", "14.3\t13.2\r\n", "13.2\t12.6\r\n", "13.0\t12.5\r\n", "13.8\t12.9\r\n", "14.0\t12.7\r\n", "12.8\t11.9\r\n", "13.2\t12.0\r\n",
	"14.8\t13.6\r\n", "13.0\t12.1\r\n", "13.0\t12.3\r\n", "13.7\t12.6\r\n", "13.7\t12.7\r\n", "13.5\t12.6\r\n", "12.8\t11.9\r\n", "13.4\t12.6\r\n", "13.5\t12.7\r\n", "15.3\t14.0\r\n",
	"12.6\t12.0\r\n", "13.7\t12.7\r\n", "14.3\t13.4\r\n", "13.4\t12.7\r\n", "13.8\t13.1\r\n", "13.9\t13.1\r\n", "12.9\t12.2\r\n", "14.3\t13.2\r\n", "15.6\t14.6\r\n", "13.8\t12.9\r\n",
	"14.0\t13.1\r\n", "13.8\t12.8\r\n", "13.5\t12.6\r\n", "12.6\t11.9\r\n", "13.6\t12.8\r\n", "13.9\t12.5\r\n", "13.7\t13.0\r\n", "15.1\t14.0\r\n", "13.9\t13.0\r\n", "13.9\t13.1\r\n",
	"13.6\t12.8\r\n", "14.2\t13.5\r\n", "13.6\t12.7\r\n", "13.9\t12.8\r\n", "14.2\t13.3\r\n", "13.2\t12.1\r\n", "13.6\t12.6\r\n", "13.9\t12.8\r\n", "15.0\t13.5\r\n", "14.2\t13.3\r\n",
	"14.6\t13.7\r\n", "13.4\t12.6\r\n", "13.4\t12.8\r\n", "14.3\t13.2\r\n", "13.8\t12.6\r\n", "13.8\t12.3\r\n", "13.9\t13.2\r\n", "12.1\t11.5\r\n", "13.9\t13.2\r\n", "14.4\t13.3\r\n",
	"13.6\t12.6\r\n", "13.1\t12.3\r\n", "13.6\t12.6\r\n", "14.9\t13.8\r\n", "13.9\t13.1\r\n", "14.1\t13.0\r\n", "13.7\t12.9\r\n", "13.2\t12.2\r\n", "13.7\t13.0\r\n", "13.6\t12.9\r\n",
	"13.2\t12.4\r\n", "13.6\t12.8\r\n", "13.6\t12.8\r\n", "14.6\t13.9\r\n", "14.4\t13.3\r\n", "13.8\t12.8\r\n", "13.9\t12.9\r\n", "13.8\t12.9\r\n", "14.8\t13.8\r\n", "13.9\t12.9\r\n",
	"14.5\t13.5\r\n", "14.7\t13.8\r\n", "12.8\t11.9\r\n", "13.8\t12.8\r\n", "13.1\t12.3\r\n", "14.4\t13.7\r\n", "13.2\t12.5\r\n", "13.2\t12.6\r\n", "13.2\t12.3\r\n", "12.9\t12.3\r\n",
	"13.3\t12.0\r\n", "14.7\t13.7\r\n", "15.3\t13.9\r\n", "13.6\t12.1\r\n", "13.6\t12.5\r\n", "13.2\t12.3\r\n", "14.2\t12.6\r\n", "13.2\t12.3\r\n", "13.8\t13.0\r\n", "12.6\t12.0\r\n",
	"14.6\t13.3\r\n", "14.6\t13.8\r\n", "13.5\t12.7\r\n", "13.4\t12.7\r\n", "13.2\t12.4\r\n", "13.5\t12.7\r\n", "15.0\t13.7\r\n", "13.4\t12.6\r\n", "13.3\t12.5\r\n", "15.7\t13.9\r\n",
	"14.5\t13.4\r\n", "14.0\t13.1\r\n", "12.6\t11.6\r\n", "13.9\t12.9\r\n", "13.5\t12.8\r\n", "13.6\t12.8\r\n", "14.1\t13.1\r\n", "14.9\t13.8\r\n", "12.9\t12.2\r\n", "13.4\t12.8\r\n",
	"12.6\t11.9\r\n", "13.9\t13.0\r\n", "13.6\t12.8\r\n", "14.5\t13.7\r\n", "14.2\t13.3\r\n", "12.8\t11.8\r\n", "12.7\t11.8\r\n", "13.4\t12.6\r\n", "14.3\t13.2\r\n", "14.0\t13.3\r\n",
	"13.2\t12.2\r\n", "14.6\t13.6\r\n", "13.3\t12.4\r\n", "13.6\t12.6\r\n", "14.0\t13.1\r\n", "14.4\t13.5\r\n", "13.0\t12.3\r\n", "13.6\t13.1\r\n", "13.0\t12.4\r\n", "14.2\t13.3\r\n",
	"14.8\t13.9\r\n", "14.0\t13.1\r\n", "14.8\t13.8\r\n", "13.5\t12.6\r\n", "15.9\t12.9\r\n", "13.4\t12.6\r\n", "13.9\t12.6\r\n", "13.3\t12.2\r\n", "14.7\t13.8\r\n", "13.2\t12.5\r\n",
	"13.3\t12.6\r\n", "13.1\t12.4\r\n", "13.0\t12.5\r\n", "13.1\t12.5\r\n", "12.8\t12.0\r\n", "13.8\t12.8\r\n", "13.8\t13.0\r\n", "13.2\t12.4\r\n", "14.0\t12.9\r\n", "14.2\t13.2\r\n",
	"13.0\t12.3\r\n", "13.7\t12.8\r\n", "14.1\t13.3\r\n", "13.6\t12.6\r\n", "13.0\t12.4\r\n", "13.8\t13.0\r\n", "13.5\t12.9\r\n", "13.2\t12.6\r\n", "13.4\t12.7\r\n", "13.6\t12.9\r\n",
	"13.4\t12.6\r\n", "14.8\t13.9\r\n", "13.1\t12.4\r\n", "13.1\t12.1\r\n", "13.8\t12.8\r\n", "13.1\t12.3\r\n", "16.8\t15.0\r\n", "14.0\t13.3\r\n", "12.8\t12.0\r\n", "13.2\t12.5\r\n",
	"13.4\t12.5\r\n", "13.0\t12.2\r\n", "13.2\t12.6\r\n", "13.9\t12.9\r\n", "12.9\t12.0\r\n", "13.7\t12.7\r\n", "14.1\t13.3\r\n", "14.7\t13.4\r\n", "14.0\t13.0\r\n", "13.0\t12.2\r\n",
	"13.3\t12.5\r\n", "13.8\t12.7\r\n", "13.8\t12.8\r\n", "13.0\t11.8\r\n", "15.0\t14.1\r\n", "13.6\t12.9\r\n", "14.0\t13.1\r\n", "12.8\t12.2\r\n", "14.4\t13.7\r\n", "13.8\t13.1\r\n",
	"12.6\t11.9\r\n", "12.8\t11.9\r\n", "13.2\t12.4\r\n", "13.3\t12.4\r\n", "14.1\t13.1\r\n", "15.1\t14.1\r\n", "13.7\t12.8\r\n", "12.9\t12.2\r\n", "14.0\t13.1\r\n", "13.9\t13.1\r\n",
	"13.5\t12.7\r\n", "13.0\t11.8\r\n", "12.8\t12.2\r\n", "13.2\t12.4\r\n", "14.5\t13.9\r\n", "14.0\t13.1\r\n", "14.8\t13.9\r\n", "13.4\t12.6\r\n", "14.0\t12.8\r\n", "14.6\t13.7\r\n",
	"14.6\t13.2\r\n", "13.6\t12.8\r\n", "14.1\t13.3\r\n", "12.6\t11.9\r\n", "13.2\t12.4\r\n", "13.9\t13.2\r\n", "11.8\t11.1\r\n", "13.3\t12.6\r\n", "12.9\t12.3\r\n", "13.7\t13.0\r\n",
	"13.5\t12.7\r\n", "13.5\t12.6\r\n", "13.8\t13.0\r\n", "14.4\t13.6\r\n", "13.1\t12.2\r\n", "13.5\t12.6\r\n", "13.6\t12.5\r\n", "13.2\t12.3\r\n", "14.1\t13.1\r\n", "15.0\t13.9\r\n",
	"13.0\t12.0\r\n", "12.6\t11.9\r\n", "13.7\t12.7\r\n", "13.1\t12.4\r\n", "14.6\t13.6\r\n", "12.8\t12.0\r\n", "13.9\t13.2\r\n", "13.7\t13.0\r\n", "13.4\t12.3\r\n", "13.4\t12.5\r\n",
	"13.8\t12.9\r\n", "13.8\t12.9\r\n", "13.0\t12.2\r\n", "14.0\t13.1\r\n", "12.7\t12.1\r\n", "12.8\t12.1\r\n", "13.2\t12.1\r\n", "14.2\t13.0\r\n", "13.1\t12.3\r\n", "13.6\t12.9\r\n",
	"13.4\t12.8\r\n", "14.2\t13.4\r\n", "14.2\t13.3\r\n", "13.2\t12.1\r\n", "13.8\t13.2\r\n", "15.0\t14.0\r\n", "12.8\t11.9\r\n", "14.5\t13.5\r\n", "13.9\t12.7\r\n", "14.0\t11.5\r\n",
	"14.4\t13.2\r\n", "13.6\t12.1\r\n", "13.9\t13.0\r\n", "14.0\t13.0\r\n", "14.0\t13.2\r\n", "13.9\t13.1\r\n", "13.8\t12.8\r\n", "13.9\t13.1\r\n", "13.2\t12.6\r\n", "14.1\t13.1\r\n",
	"13.7\t13.0\r\n", "14.6\t13.2\r\n", "14.2\t13.5\r\n", "14.0\t13.4\r\n", "13.7\t12.2\r\n", "13.9\t13.1\r\n", "13.9\t13.2\r\n", "13.8\t12.9\r\n", "13.6\t12.7\r\n", "14.2\t13.5\r\n",
	"13.9\t13.1\r\n", "13.4\t12.8\r\n", "14.8\t13.5\r\n", "13.7\t12.6\r\n", "15.0\t13.8\r\n", "13.5\t12.5\r\n", "14.0\t13.2\r\n", "16.6\t14.9\r\n", "13.4\t12.7\r\n", "13.8\t13.1\r\n",
	"14.0\t13.1\r\n", "13.7\t13.1\r\n", "13.9\t13.1\r\n", "13.0\t12.4\r\n", "13.3\t12.6\r\n", "13.3\t12.6\r\n", "14.5\t13.7\r\n", "14.4\t13.5\r\n", "14.0\t13.2\r\n", "14.4\t13.5\r\n",
	"14.1\t12.9\r\n", "13.9\t13.1\r\n", "14.8\t14.1\r\n"
};


size_t random_index(void)
{
	Random r;
	r.setSeedRandomly();
	const size_t idx = r.nextInt();

	LOG_MSG("random index=" << idx);

	return idx;
}


std::string TabCanvas::get_simulated_string(VBytes & read_buffer)
{
	read_buffer[0] = '\0';

	static thread_local size_t idx = random_index();

	const std::string str = sample_data[idx % sample_data.size()];
	idx++;

	return str;
}
