# GMM (C) 2018 Stephane Charette <stephanecharette@gmail.com>
# $Id: CM_source.cmake 2665 2018-11-21 08:44:44Z stephane $


# get rid of the directories and files automatically created by Introjucer since we're using our own CMake build files
FILE ( REMOVE_RECURSE Builds Source )

# build JUCE prior to enabling Wall Wextra Werror
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/JuceLibraryCode )
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/JuceLibraryCode/modules )
ADD_SUBDIRECTORY ( src-juce )

IF ( UNIX )
	ADD_DEFINITIONS ( "-Wall -Wextra -Werror -Wno-unused-parameter" )
ENDIF ()

INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-misc/		)
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-img/		)
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-log/		)
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-cfg/		)
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-wnd/		)
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-gmm/		)

ADD_SUBDIRECTORY ( src-misc 	)
ADD_SUBDIRECTORY ( src-img		)
ADD_SUBDIRECTORY ( src-log		)
ADD_SUBDIRECTORY ( src-cfg		)
ADD_SUBDIRECTORY ( src-wnd		)
ADD_SUBDIRECTORY ( src-gmm		)

ADD_SUBDIRECTORY ( other-ubuntu	)
ADD_SUBDIRECTORY ( other-win64	)

ADD_SUBDIRECTORY ( src-opc		)

ADD_SUBDIRECTORY ( doxygen		)
