/* GMM (C) 2018 Stephane Charette <stephanecharette@gmail.com>
 * $Id: LoadWnd.hpp 2605 2018-09-17 18:04:51Z stephane $
 */

#pragma once

#include "GMM.hpp"


class LoadWnd final : public ThreadWithProgressWindow
{
	public:

		bool finished_loading;
		double total_number_of_items_to_load;
		double progress_level;

		LoadWnd(void);
		virtual ~LoadWnd(void);

		virtual void update_progress_bar(const double progress = 1.0, const std::string msg="");

		/// Return a simple text string, such as "Loading...", but randomly put a twist on it.
		virtual std::string get_status_message(void);

		/// Inherited from ThreadWithProgressWindow.
		virtual void run( void );

		/// See if there is a new version of the software available.
		virtual void check_for_new_version(void);

		/// See if there is a MOTD to display to the user.
		virtual void check_for_motd(void);

		/// See if this version of the client seems to be out-of-date.
		virtual void check_build_timestamp(void);

		/// Find all devices named in configuration.
		void find_all_devices(void);

		/// Make sure that every device has all the required fields.
		void fix_all_devices(void);
};
