/* GMM (C) 2018-2019 Stephane Charette <stephanecharette@gmail.com>
 * $Id: Cfg.hpp 2718 2019-02-07 07:08:42Z stephane $
 */

#pragma once

#include "GMM.hpp"


class Cfg final : public PropertiesFile
{
	public:

		Cfg(void);

		virtual ~Cfg(void);

		virtual Cfg &first_time_initialization(void);

		virtual Cfg &insert_if_not_exist(const std::string &key, const std::string &val);
		virtual Cfg &insert_if_not_exist(const std::string &key, const int &val);

		virtual Cfg &set_str(const std::string &key, const std::string &val);

		/// The key must exist, otherwise an exception is thrown.
		virtual std::string get_str(const std::string &key);

		/// Return the corresponding value, or the default value if the key does not exist.
		virtual std::string get_str(const std::string &key, const std::string &default_value);

		/// The key must exist, otherwise an exception is thrown.
		virtual int get_int(const std::string &key);

		/// Return the corresponding value, or the default value if the key does not exist.
		virtual bool get_bool(const std::string &key, const bool default_value=true);
};
