/* GMM (C) 2018-2019 Stephane Charette <stephanecharette@gmail.com>
 * $Id: GMMLookAndFeel.hpp 2718 2019-02-07 07:08:42Z stephane $
 */

#pragma once

#include "GMM.hpp"


/// Customized JUCE look-and-feel.
class GMMLookAndFeel final : public LookAndFeel_V4
{
	public:

		/// Constructor.
		GMMLookAndFeel( LookAndFeel_V4::ColourScheme colour_scheme );

		/// Destructor.
		virtual ~GMMLookAndFeel( void );

		/// Inherited from LookAndFeel to use a lighter background colour.
		virtual void drawCallOutBoxBackground( CallOutBox &box, Graphics &g, const Path &path, Image &cachedImage );
};


GMMLookAndFeel *init_gmm_look_and_feel(void);

void reset_gmm_look_and_feel(void);
