/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_base.hpp 1729 2016-03-30 07:04:48Z stephane $
 */

#pragma once

// Central include file for SeeedGrove++ is "sg++.hpp".

#include <string>
#include "sg_version.hpp"


namespace SG
{
	/// Format the compiler macros `__DATE__` and `__TIME__` to make a readable timestamp showing when this project was last built.
	std::string get_build_timestamp( void );

	/// Get the version string.
	std::string get_version( void );

	/// Demangle the C++ function or variable name.  Sometimes useful in error messages.
	std::string demangle( const std::string &name );
}
