/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_101020015_TemperatureSensor.cpp 1732 2016-04-01 05:22:06Z stephane $
 */

#include "sg_101020015_TemperatureSensor.hpp"
#include "sg_103020013_I2CADC.hpp"
#include "sg++.hpp"

#include <cmath>


SG::TemperatureSensor::~TemperatureSensor( void )
{
	//	SG::SGpp::get().gpio.gpio_unexport( 2 );	// P9_22 -- GPIO_2

	return;
}


SG::TemperatureSensor::TemperatureSensor( SG::I2CADC &adc, const std::string &n, const EType etype ) :
		GroveI2C( SG::EGroveType::kTemperatureSensorV12 ),
		i2cadc(adc),
		type(etype)
{
	return;
}


SG::TemperatureSensor::TemperatureSensor( const SG::TemperatureSensor &rhs ) :
		GroveI2C( rhs.get_type(), rhs.get_name() ),
		i2cadc( rhs.i2cadc )
{
	return;
}


SG::TemperatureSensor &SG::TemperatureSensor::operator=( const SG::TemperatureSensor &rhs )
{
	if (this != &rhs)
	{
		GroveI2C::operator=( rhs );
	}

	return *this;
}


bool SG::TemperatureSensor::operator==( const SG::TemperatureSensor &rhs ) const
{
	return GroveI2C::operator==(rhs);
}


/// @todo This needs to be removed once get_celsius boooooo
#include <iostream>

double SG::TemperatureSensor::get_celsius(void)
{
//	std::cout << std::endl << std::endl;

	double B = static_cast<double>(type);
	if (B == 0.0)
	{
		// prevent divide-by-zero in the math below if the type is invalid
		B = 1.0;
	}
	std::cout << "B=" << B << std::endl;

	const double analog = i2cadc.get_result();
	std::cout << "analog=" << analog << std::endl;

	const double resistance = 1023.0 / analog - 1.0;
	std::cout << "resistance=" << resistance << std::endl;

	const double celsius = 1.0 / (std::log(resistance) / B + 1.0/298.15) - 273.15;

	return celsius;
}


double SG::TemperatureSensor::get_fahrenheit(void)
{
	return 32.0 + get_celsius() * 9.0/5.0;
}
