/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_i2c-dev.h 1729 2016-03-30 07:04:48Z stephane $
 *
 * The contents of this file are not written by Stephane Charette for Seeed Grove ++, but instead come from
 * /usr/include/linux/i2c-dev.h, and are copied here for convenience to solve a compile/link issue.
 * See comment below for details.
 */

#pragma once

#include <sys/ioctl.h>
#include <linux/i2c.h>
#include <linux/i2c-dev.h>


/** @todo
 * 
 * If cross-compiling for ARM on older versions of Ubuntu, note the following files are *not* the same:
 *
 * * @p /usr/include/linux/i2c-dev.h
 * * @p /usr/arm-linux-gnueabi/include/linux/i2c-dev.h
 *
 * To get around this issue, I've copied a few of the necessary i2c_smbus_* functions from the newer
 * file in @p /usr/include/linux/i2c-dev.h.
 */


#ifndef i2c_smbus_access
static inline __s32 i2c_smbus_access(int file, char read_write, __u8 command, int size, union i2c_smbus_data *data)
{
	struct i2c_smbus_ioctl_data args;
	args.read_write = read_write;
	args.command = command;
	args.size = size;
	args.data = data;
	return ioctl(file, I2C_SMBUS, &args);
}
#endif


#ifndef i2c_smbus_read_byte_data
static inline __s32 i2c_smbus_read_byte_data(int file, __u8 command)
{
	union i2c_smbus_data data;
	if (i2c_smbus_access(file, I2C_SMBUS_READ, command, I2C_SMBUS_BYTE_DATA, &data))
	{
		return -1;
	}
	else
	{
		return 0x0FF & data.byte;
	}
}
#endif


#ifndef i2c_smbus_write_byte_data
static inline __s32 i2c_smbus_write_byte_data(int file, __u8 command, __u8 value)
{
	union i2c_smbus_data data;
	data.byte = value;
	return i2c_smbus_access(file, I2C_SMBUS_WRITE,command, I2C_SMBUS_BYTE_DATA, &data);
}
#endif


#ifndef i2c_smbus_read_word_data
static inline __s32 i2c_smbus_read_word_data(int file, __u8 command)
{
	union i2c_smbus_data data;
	if (i2c_smbus_access(file,I2C_SMBUS_READ,command, I2C_SMBUS_WORD_DATA,&data))
	{
		return -1;
	}
	else
	{
		return 0x0FFFF & data.word;
	}
}
#endif


#ifndef i2c_smbus_write_word_data
static inline __s32 i2c_smbus_write_word_data(int file, __u8 command, __u16 value)
{
	union i2c_smbus_data data;
	data.word = value;
	return i2c_smbus_access(file,I2C_SMBUS_WRITE,command, I2C_SMBUS_WORD_DATA, &data);
}
#endif
