/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_FD.hpp 1808 2016-04-28 22:17:03Z stephane $
 */

#pragma once

// Central include file for SeeedGrove++ is "sg++.hpp".

#include <memory>
#include <string>


namespace SG
{
	/** Used in combination with shared_ptr to reference count open file descriptors.  This ensures that the file
	 * handle isn't prematurely closed when shared between different objects.  For example, in objects that derive
	 * from @ref SG::GroveI2CDigital, the open file handle to @p /dev/i2c-1 may be shared between several objects and
	 * must not be closed until the last object goes out of scope.
	 */
	class FD final
	{
		public:

			/// Constructor.  Optionally takes an existing open file descriptor.
			FD(const int i=-1);

			/// Constructor.  Requires the name of the file to be opened.  File is opened in read-write mode.
			FD(const std::string &filename);

			/// Constructor.  Requires the name of the file to be opened and the mode (O_RDONLY, O_WRONLY, O_RDWR).
			FD(const std::string &filename, const int mode);

			/// Destructor.
			~FD(void);

			/// Determine if the file handle is valid.
			bool is_valid(void) const { return fd >= 0; }

			/// File descriptor.
			int fd;
	};

	/// Shared open file descriptor.  The file will be closed once the last shared object goes out of scope.  @see @ref SG::FD
	typedef std::shared_ptr<FD> SharedFileDescriptor;
}
