/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_GroveI2CAnalog.hpp 1739 2016-04-04 07:42:44Z stephane $
 */

#pragma once

// Central include file for SeeedGrove++ is "sg++.hpp".

#include "sg_groves.hpp"
#include "sg_GroveI2C.hpp"


namespace SG
{
	/// Base class for analog I2C Groves sensors.
	class GroveI2CAnalog : public GroveI2C
	{
		public:

			/// Constructor.
			GroveI2CAnalog( const SG::EGroveType t = SG::EGroveType::kUnknown, const std::string &n = "" );

			/// Destructor.
			virtual ~GroveI2CAnalog( void );

			virtual bool is_analog	( void ) const { return true; }		///< This is always @p true for GroveI2CDigital.
			virtual bool is_digital	( void ) const { return false; }	///< This is always @p false for GroveI2CDigital.
	};
}
