# Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
# $Id: CM_definitions.cmake 1795 2016-04-26 19:29:17Z stephane $


IF ( CMAKE_SIZEOF_VOID_P EQUAL 8 )
	SET ( SG_BIT_SIZE 64 )
ELSEIF ( CMAKE_SIZEOF_VOID_P EQUAL 4 )
	SET ( SG_BIT_SIZE 32 )
ELSE ()
	MESSAGE ( FATAL_ERROR "CMAKE_SIZEOF_VOID_P=${CMAKE_SIZEOF_VOID_P}" )
ENDIF ()

ADD_DEFINITIONS ( "-std=gnu++11 -fPIC -Wall -Wextra -Werror -Wno-unused-parameter" )

MESSAGE ( "Building with ${CMAKE_C_COMPILER}"	)
MESSAGE ( "Building with ${CMAKE_CXX_COMPILER}"	)


STRING (FIND "${CMAKE_CXX_COMPILER}" "arm-linux-gnueabihf-g++" pos)
IF ( ${pos} EQUAL -1 )
	SET ( SG_CROSS_COMPILE_FOR_ARM7 FALSE )
ELSE ()
	MESSAGE ( "Cross compiling for ARM7" )
	SET ( SG_CROSS_COMPILE_FOR_ARM7 TRUE )
ENDIF ()


STRING (FIND "${CMAKE_SYSTEM_PROCESSOR}" "arm" pos)
IF ( ${pos} EQUAL -1 )
	SET ( SG_COMPILE_FOR_ARM7 FALSE )
ELSE ()
	MESSAGE ( "Compiling for ARM" )
	SET ( SG_COMPILE_FOR_ARM7 TRUE )
ENDIF ()


IF ( ${SG_CROSS_COMPILE_FOR_ARM7} OR ${SG_COMPILE_FOR_ARM7} )
	SET ( SG_SYSTEM_NAME "armhf-${SG_BIT_SIZE}" )
ELSE ()
	IF ( SG_BIT_SIZE EQUAL 32 )
		SET ( SG_SYSTEM_NAME "x86-${SG_BIT_SIZE}" )
	ELSE ()
		SET ( SG_SYSTEM_NAME "amd-${SG_BIT_SIZE}" )
	ENDIF ()
ENDIF ()
