/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_LED_patterns.cpp 1732 2016-04-01 05:22:06Z stephane $
 */

#include "sg_LED_patterns.hpp"


SG::BeagleBone::BlinkPattern SG::BeagleBone::LED_invert_pattern( const SG::BeagleBone::BlinkPattern &pattern )
{
	/** Reverse all values of @p "on" and @p "off" in a pattern.  For example, given the pattern
	 * @ref LED_pattern_none(), calling this method would result in the same pattern as @ref LED_pattern_all().
	 */

	BlinkPattern inverted_pattern;

	// for each step in a pattern...
	for ( const PatternStep &step : pattern )
	{
		// get each on/off setting in this step, and reverse it
		PatternStep inverted_step;
		for ( const auto iter : step )
		{
			const LED led		= iter.first;
			const bool value	= ! iter.second;

			inverted_step[ led ] = value;
		}

		// remember this inverted step before we process the next one
		inverted_pattern.push_back( inverted_step );
	}

	return inverted_pattern;
}


SG::BeagleBone::BlinkPattern SG::BeagleBone::LED_pattern_none( void )
{
	// turn off every LED

	BlinkPattern pattern;
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );

	return pattern;
}


SG::BeagleBone::BlinkPattern SG::BeagleBone::LED_pattern_all( void )
{
	// turn on every LED

	BlinkPattern pattern;
	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, true	},	{ LED::usr2, true	},	{ LED::usr3, true	}	} );

	return pattern;
}


SG::BeagleBone::BlinkPattern SG::BeagleBone::LED_pattern_blink( void )
{
	// blink every LED

	BlinkPattern pattern;
	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, true	},	{ LED::usr2, true	},	{ LED::usr3, true	}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );

	return pattern;
}


SG::BeagleBone::BlinkPattern SG::BeagleBone::LED_pattern_blinkOffset( void )
{
	// blink even and odd lights

	BlinkPattern pattern;
	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, 0		},	{ LED::usr2, true	},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, true	},	{ LED::usr2, 0		},	{ LED::usr3, true	}	} );

	return pattern;
}


SG::BeagleBone::BlinkPattern SG::BeagleBone::LED_pattern_blinkSplit( void )
{
	// blink left lights, then right lights

	BlinkPattern pattern;
	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, true	},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, true	},	{ LED::usr3, true	}	} );

	return pattern;
}


SG::BeagleBone::BlinkPattern SG::BeagleBone::LED_pattern_cylon( void )
{
	// multi-light sweep

	BlinkPattern pattern;

	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, true	},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, true	},	{ LED::usr2, true	},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, true	},	{ LED::usr2, true	},	{ LED::usr3, true	}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, true	},	{ LED::usr3, true	}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, true	}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, true	},	{ LED::usr3, true	}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, true	},	{ LED::usr2, true	},	{ LED::usr3, true	}	} );
	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, true	},	{ LED::usr2, true	},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, true	},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );

	return pattern;
}


SG::BeagleBone::BlinkPattern SG::BeagleBone::LED_pattern_kitt( void )
{
	// single light sweep

	BlinkPattern pattern;

	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, true	},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, true	},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, true	}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, true	},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, true	},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );

	return pattern;
}


SG::BeagleBone::BlinkPattern SG::BeagleBone::LED_pattern_mergeLeft( void )
{
	BlinkPattern pattern;

	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, true	}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, true	},	{ LED::usr3, true	}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, true	},	{ LED::usr2, true	},	{ LED::usr3, true	}	} );
	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, true	},	{ LED::usr2, true	},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, true	},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );

	return pattern;
}


SG::BeagleBone::BlinkPattern SG::BeagleBone::LED_pattern_mergeRight( void )
{
	BlinkPattern pattern;

	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, true	},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, true	},	{ LED::usr2, true	},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, true	},	{ LED::usr2, true	},	{ LED::usr3, true	}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, true	},	{ LED::usr3, true	}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, true	}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );

	return pattern;
}


SG::BeagleBone::BlinkPattern SG::BeagleBone::LED_pattern_mergeBoth( void )
{
	// combine the two merge patterns together

	const SG::BeagleBone::BlinkPattern left		= LED_pattern_mergeLeft();
	const SG::BeagleBone::BlinkPattern right	= LED_pattern_mergeRight();
	const SG::BeagleBone::BlinkPattern none		= LED_pattern_none();

	BlinkPattern pattern;
	pattern.insert( pattern.end(), left	.begin(), left	.end() );
	pattern.insert( pattern.end(), none	.begin(), none	.end() );
	pattern.insert( pattern.end(), right.begin(), right	.end() );
	pattern.insert( pattern.end(), none	.begin(), none	.end() );

	return pattern;
}


SG::BeagleBone::BlinkPattern SG::BeagleBone::LED_pattern_inchwormLeft( void )
{
	// inchworm moving right-to-left
	
	BlinkPattern pattern;

	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, true	}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, true	},	{ LED::usr3, true	}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, true	},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, true	},	{ LED::usr2, true	},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, true	},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, true	},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );

	return pattern;
}


SG::BeagleBone::BlinkPattern SG::BeagleBone::LED_pattern_inchwormRight( void )
{
	// inchworm moving left-to-right

	BlinkPattern pattern;

	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, true	},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, true	},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, true	},	{ LED::usr2, true	},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, true	},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, true	},	{ LED::usr3, true	}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, true	}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, 0		}	} );

	return pattern;
}


SG::BeagleBone::BlinkPattern SG::BeagleBone::LED_pattern_inchwormBoth( void )
{
	// combine the two inchworm patterns together

	const SG::BeagleBone::BlinkPattern left		= LED_pattern_inchwormLeft();
	const SG::BeagleBone::BlinkPattern right	= LED_pattern_inchwormRight();

	BlinkPattern pattern;
	pattern.insert( pattern.end(), left	.begin(), left	.end() );
	pattern.insert( pattern.end(), right.begin(), right	.end() );

	return pattern;
}


SG::BeagleBone::BlinkPattern SG::BeagleBone::LED_pattern_insideOut( void )
{
	BlinkPattern pattern;

	pattern.push_back( {	{ LED::usr0, 0		},	{ LED::usr1, true	},	{ LED::usr2, true	},	{ LED::usr3, 0		}	} );
	pattern.push_back( {	{ LED::usr0, true	},	{ LED::usr1, 0		},	{ LED::usr2, 0		},	{ LED::usr3, true	}	} );

	return pattern;
}
