/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_base.cpp 1864 2016-05-26 06:07:33Z stephane $
 */

#include "sg_base.hpp"
#include "sg_version.hpp"
#include <sstream>
#include <fstream>
#include <cctype>
#include <cxxabi.h>
#include <unistd.h>
#include <sys/stat.h>


std::string SG::get_version( void )
{
	/// Format should be similar to @p "0.0.1-1443".

	return SG_VERSION;
}


std::string SG::demangle( const std::string &name )
{
	std::string demanged_name = name;

	int status = -1;
	char *ptr = abi::__cxa_demangle( name.c_str(), nullptr, nullptr, &status );

	if (status == 0 && ptr)		demanged_name = ptr;
	if (ptr)					free(ptr);

	return demanged_name;
}


bool SG::file_exists( const std::string &filename )
{
	struct stat sb;
	const int rc = stat( filename.c_str(), &sb );
	if (rc == 0)
	{
		if (S_ISDIR(sb.st_mode) == false)
		{
			// not a directory, so must be some type of file
			return true;
		}
	}

	return false;
}


std::string SG::read_file( const std::string &filename )
{
	std::stringstream ss;

	std::ifstream fs( filename );
	if (fs.good())
	{
		ss << fs.rdbuf();
	}

	return ss.str();
}


std::string SG::trim( const std::string &str )
{
	std::string txt = str;
	trim(txt);

	return txt;
}


std::string &SG::trim( std::string &str )
{
	size_t len = str.length();

	// trim the end of the string
	while (len)
	{
		if (std::isspace( str[len - 1] ))
		{
			str.erase( len - 1 );
			len --;
			continue;
		}

		break;
	}

	// trim the front of the string
	while (len)
	{
		if (std::isspace( str[0] ))
		{
			str.erase( 0, 1 );
			len --;
			continue;
		}

		break;
	}

	return str;
}
