/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_base.hpp 1862 2016-05-25 00:06:15Z stephane $
 */

#pragma once

// Central include file for SeeedGrove++ is "sg++.hpp".

#include <string>
#include "sg_version.hpp"


namespace SG
{
	/// Format the compiler macros `__DATE__` and `__TIME__` to make a readable timestamp showing when the SG++ library was last built.
	std::string get_build_timestamp( void );

	/// Get the version string.
	std::string get_version( void );

	/// Demangle the C++ function or variable name.  Sometimes useful in error messages.
	std::string demangle( const std::string &name );

	/// Determine if the specified file exists.
	bool file_exists( const std::string &filename );

	/// Determine if the specified file does not exist.
	inline bool file_does_not_exist( const std::string &filename ) { return ! file_exists(filename); }

	/// Read the specified file into a single std::string.
	std::string read_file( const std::string &filename );

	/// Trim whitespace and return a new string, leaving the original string unchanged.
	std::string trim( const std::string &str );

	/// Trim whitespace from the provided string.  Modifies the original string.
	std::string &trim( std::string &str );
}
