/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_8x8_CourierNew.hpp 1776 2016-04-17 04:52:34Z stephane $
 */

#pragma once

// Central include file for SeeedGrove++ is "sg++.hpp".

#include "sg_Monospace.hpp"


namespace SG
{
	namespace Font
	{
		/** Standard Courier New font for 7-bit ASCII characters between 32 and 127.  The size of 8x8 includes vertical and
		* horizontal blank space needed between characters.  For Courier New, this means a blank row on the bottom, and a
		* blank column on the left.  Without the blank space, the actual characters are 7x7 (or smaller and padded).
		*
		* @image html CourierNew_8x8.png
		*/
		class CourierNew : public Monospace
		{
			public:

				CourierNew(void);			///< Constructor.
				virtual ~CourierNew(void);	///< Destructor.

				virtual std::string	get_name	(void) const { return "Courier New"; }	///< Get the font name.  For Courier New, this will always return <tt>Courier New</tt>.
				virtual Fontmap		get_fontmap	(void) const;							///< Get the actual font bitmap.
		};
	}
}
