/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_8x8_DejaVuSans.hpp 1776 2016-04-17 04:52:34Z stephane $
 */

#pragma once

// Central include file for SeeedGrove++ is "sg++.hpp".

#include "sg_Monospace.hpp"


namespace SG
{
	namespace Font
	{
		/** Standard Deja Vu Sans font for 7-bit ASCII characters between 32 and 127.  The size of 8x8 includes vertical
		* and horizontal blank space needed between characters.  For Deja Vu Sans, this means a blank row on the bottom,
		* and a blank column on the left.  Without the blank space, the actual characters are 7x7 (or smaller and padded).
		*
		* @image html DejaVuSansMono_8x8.png
		*/
		class DejaVuSans : public Monospace
		{
			public:

				DejaVuSans(void);			///< Constructor.
				virtual ~DejaVuSans(void);	///< Destructor.

				virtual std::string	get_name	(void) const { return "Deja Vu Sans"; }	///< Get the font name.  For Deja Vu Sans, this will always return <tt>Deja Vu Sans</tt>.
				virtual Fontmap		get_fontmap	(void) const;							///< Get the actual font bitmap.
		};
	}
}
