/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_Font.cpp 1776 2016-04-17 04:52:34Z stephane $
 */

#include "sg_Font.hpp"


std::shared_ptr<SG::Font::Monospace> SG::Font::get( const SG::Font::EType type )
{
	std::shared_ptr<SG::Font::Monospace> font;

	switch( type )
	{
		case EType::kInvalid:			font = std::make_shared<CapRouge>();	break;
		case EType::k8x8CapRouge:		font = std::make_shared<CapRouge>();	break;
		case EType::k8x8CourierNew:		font = std::make_shared<CourierNew>();	break;
		case EType::k8x8DejaVuSans:		font = std::make_shared<DejaVuSans>();	break;
		case EType::k8x8UbuntuMono:		font = std::make_shared<UbuntuMono>();	break;
		// do not add a "default" case, so we'll get a compile-time error if a new font type is added
	}

	return font;
}
