/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_Monospace.hpp 1817 2016-05-01 00:18:10Z stephane $
 */

#pragma once

// Central include file for SeeedGrove++ is "sg++.hpp".

#include <map>
#include <string>
#include <vector>


namespace SG
{
	namespace Font
	{
		/** Very simple 8x8 monospace font, typically for 7-bit ASCII characters between 0x20 and 0x7f.
		*
		* @see @ref SG::Font::EType
		* @see @ref SG::Font::get()
		*/
		class Monospace
		{
			public:

				typedef std::vector<bool>		Bitmap;					///< Bitmap of a single character, showing which pixels to turn on/off.
				typedef std::map<char, Bitmap>	Fontmap;				///< Map of every character in this font.

				Monospace					(void);						///< Constructor.
				virtual ~Monospace			(void);						///< Destructor.
				virtual size_t get_width	(void) const { return 8; }	///< Get the width of each character.
				virtual size_t get_height	(void) const { return 8; }	///< Get the height of each character.
				virtual std::string get_name(void) const = 0;			///< Get the font name.
				virtual Fontmap get_fontmap	(void) const = 0;			///< Get the actual font bitmap.

				/// Get a bitmap to use for the given ASCII character. @{
				virtual Bitmap get(char c) const { return get(c, get_fontmap()); }
				virtual Bitmap get(char c, const Fontmap &font_map) const;
				/// @}
		};
	}
}
