/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_101020003_Button.cpp 1863 2016-05-25 01:01:30Z stephane $
 */

#include "sg_101020003_Button.hpp"
#include "sg++.hpp"
#include <chrono>


SG::Button::~Button( void )
{
	SG::SGpp::get().gpio.gpio_unexport(2);	// P9_22 -- GPIO_2

	return;
}


SG::Button::Button( const std::string &n ) :
		GroveGPIO( SG::EGroveType::kButton, n )
{
	SG::SGpp::get().gpio.gpio_export( 2, GpioManagement::EDirection::kInput );

	return;
}


bool SG::Button::is_down( void )
{
	// "The button outputs a HIGH signal when pressed, and LOW when released."

	const bool result = SG::SGpp::get().gpio.get_bool(2);
	
	return result;
}


bool SG::Button::wait_for_button_down( const size_t timeout_in_milliseconds )
{
	const auto end_time = std::chrono::high_resolution_clock::now() + std::chrono::milliseconds(timeout_in_milliseconds);
	bool result = true;

	while (is_up())
	{
		if (timeout_in_milliseconds > 0 && std::chrono::high_resolution_clock::now() > end_time)
		{
			// we ran out of time
			result = false;
			break;
		}

		std::this_thread::sleep_for( std::chrono::milliseconds(100) );
	}

	return result;
}


bool SG::Button::wait_for_button_up( const size_t timeout_in_milliseconds )
{
	const auto end_time = std::chrono::high_resolution_clock::now() + std::chrono::milliseconds(timeout_in_milliseconds);
	bool result = true;

	while (is_down())
	{
		if (timeout_in_milliseconds > 0 && std::chrono::high_resolution_clock::now() > end_time)
		{
			// we ran out of time
			result = false;
			break;
		}

		std::this_thread::sleep_for( std::chrono::milliseconds(100) );
	}

	return result;
}


bool SG::Button::wait_for_transition( const size_t timeout_in_milliseconds )
{
	bool result = is_up();
	if (result)
	{
		result = wait_for_button_down(timeout_in_milliseconds);
	}
	else
	{
		result = wait_for_button_up(timeout_in_milliseconds);
	}

	return result;
}
