/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_104020006_LEDBar.hpp 1852 2016-05-21 15:28:41Z stephane $
 */

#pragma once

#include "sg_GroveGPIO.hpp"


namespace SG
{
	/** I2C 10-segment LED gauge bar.
	 * 
	 * The LED segments are as follows:
	 * * one red
	 * * one yellow
	 * * eight green
	 *
	 * This twig uses a MY-Semi MY9221 LED control chip.  Each LED segment can be individually controlled, and set to
	 * different intensity levels.
	 *
	 * Connect the OLED display to the right-hand-side GPIO interface.
	 *
	 * @see http://www.seeedstudio.com/wiki/Grove_-_LED_Bar
	 * @see http://www.seeedstudio.com/depot/Grove-LED-Bar-v20-p-2474.html
	 * @see http://www.seeedstudio.com/wiki/images/9/98/MY9221_DS_1.0.pdf
	 * @see http://www.my-semi.com.tw/file/MY9221_BF_3.0.pdf
	 */
	class LEDBar : public GroveGPIO
	{
		public:

			/** The command is 16 bits wide, and the colour data is 12 x 16 bits.  This makes a total of 208 bits, or
			 * 26 bytes.  See pages 12-14 of the datasheet for details.  By default, only the lower 8 bits of each
			 * colour is used, and the upper 8 bits remain at zero.
			 *
			 * @note The LED Bar only uses the first 10 colours of the 12 possible colours supported by the MY9221.
			 * The upper two sets of 16-bit colour values (@p colour[10] and @p colour[11]) are ignored.
			 * 
			 * The colours are assigned as follows:
			 * * colour[0] through colour[7] are green
			 * * colour[8] is yellow
			 * * colour[9] is red
			 */
			struct Data final
			{
				uint16_t command;
				uint16_t colour[12];

				Data(void) :
					command( 0 ),	// default values (such as 8-bit colour & 8.6MHz internal oscillator) are all zero
					colour {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
				{
					return;
				}
			};

			/// Destructor.
			virtual ~LEDBar( void );

			/// Constructor.
			LEDBar( const std::string &n="" );

			virtual LEDBar &all_on(void);
			virtual LEDBar &all_off(void);
			virtual LEDBar &toggle( const size_t led_idx, const uint8_t intensity = 127 );

			virtual LEDBar &send_data( const Data &data );
	};
}
