/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_104030008_OLED112.cpp 1817 2016-05-01 00:18:10Z stephane $
 */

#include "sg_104030008_OLED112.hpp"


SG::OLED112::~OLED112( void )
{
	return;
}


SG::OLED112::OLED112( const std::string &n, const SG::GroveI2CDigital::I2CAddress addr ) :
		SG::CommonOLED( SG::EGroveType::kOLEDDisplay1_12, n, addr )
{
	return;
}


SG::OLED112 &SG::OLED112::reset(void)
{
	/** The OLED112 uses the Solomon Systech SSD1308 (128x64 dot matrix).  Inspiration for the commands in @p reset()
	 * came from LY190-128064.pdf section 9.4.  Additional details came from SSD1308_1.0.pdf sections 8-9, pages 27-44.
	 */

	const I2CBlock cmd2 =
	{
		0x80,
//		0xa8,	0x3f,	// set multiplex ratio
//		0xad,	0x00,	// select external IREF
		0xb0,			// set GDDRAM page start address
		0xc0,			// set COM output scan direction
		0xd3,	0x00,	// set vertical display offset

		0xd5,	0x80,	// set display clock dividie ratio/oscillator frequency
		0xd9,	0x22,	// set pre-charge period
		0xda,	0x12,	// set COM pins hardware configuration
		0xdb,	0x20,	// set VCOMH deselect level
	};

//	write_block( cmd2 );

	unlock					(				);
	turn_off				(				);
	stop_scrolling			(				);
	send_command			( 0xa8, 0x3f	);	// set multiplex ratio
	send_command			( 0xad, 0x00	);	// select external IREF
	send_command			( 0xd5, 0x80	);	// set display clock divide ratio/oscillator frequency
//	send_command			( 0xd9, 0x22	);	// set pre-charge period
//	send_command			( 0xda, 0x12	);	// set COM pins hardware configuration
//	send_command			( 0xdb, 0x20	);	// set VCOMH deselect level
	set_contrast			( 0x7f			);
	set_orientation			( EOrientation::kLandscape		);
//	set_orientation			( EOrientation::kLandscape180	);
	clear_screen			(				);
	normal_display			(				);
	do_not_invert_display	(				);
	set_XY					( 0, 0			);
	turn_on					(				);

#if 0
	
	// this next block is for the 96x96, not the 1.12"
	I2CBlock cmds
	{
		0xFD, 0x12,		// unlock
		0xAE,			// set display off
		0xA8, 0x5F,		// set multiplex ratio
		0xA1,			// WHAT??? set display start line
		0x00,			// WHAT???
		0xA2, 0x60,		// WHAT??? set display offset
		0xA0,			// set remap
		0x46,			// ???
		0xAB, 0x01,		// set vdd internal
		0x81, 0x53,		// set contrast
		0xB1, 0X51,		// set phase length
		0xB3,			// set display clock divide ratio/oscillator frequency
			0x01,
			0xB9,
		0xBC, 0x08,		// set pre_charge voltage/VCOMH
		0xBE, 0X07,		// set VCOMH
		0xB6, 0x01,		// set second pre-charge period
		0xD5, 0X62,		// enable second precharge and enternal vsl
		0xA4,			// set normal display mode
		0x2E,			// deactivate scroll
		0xAF			// switch on display
	};
//	write_block( cmds );
#endif

	set_orientation			( EOrientation::kLandscape		);
//	set_orientation			( EOrientation::kLandscape180	);

	fade_black_to_white();
	fade_white_to_black();

	set_font( Font::EType::k8x8CapRouge		);	show( " !\"#$%&'()*+,-./"	);
	set_font( Font::EType::k8x8CourierNew	);	show( " !\"#$%&'()*+,-./"	);
	set_font( Font::EType::k8x8CapRouge		);	show( "0123456789:;<=>?"	);
	set_font( Font::EType::k8x8CourierNew	);	show( "0123456789:;<=>?"	);
	set_font( Font::EType::k8x8CapRouge		);	show( "@ABCDEFGHIJKLMNO"	);
	set_font( Font::EType::k8x8CourierNew	);	show( "@ABCDEFGHIJKLMNO"	);
	set_font( Font::EType::k8x8CapRouge		);	show( "PQRSTUVWXYZ[\\]^_"	);
	set_font( Font::EType::k8x8CourierNew	);	show( "PQRSTUVWXYZ[\\]^_"	);
	set_font( Font::EType::k8x8CapRouge		);	show( "`abcdefghijklmno"	);
	set_font( Font::EType::k8x8CourierNew	);	show( "`abcdefghijklmno"	);
	set_font( Font::EType::k8x8CapRouge		);	show( "pqrstuvwxyz{|}~\x7f"	);
	set_font( Font::EType::k8x8CourierNew	);	show( "pqrstuvwxyz{|}~\x7f"	);
	set_font( Font::EType::k8x8CapRouge		);	show( "StephaneCharette"	);
	set_font( Font::EType::k8x8CapRouge		);	show( "Jolie was here!"		);

	return *this;
}


SG::OLED112 &SG::OLED112::clear_screen(void)
{
	stop_scrolling();

	const I2CBlock block( pixel_width() * pixel_height(), 0x00 );
	flood(block);

	return *this;
}
