/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_107020000_Buzzer.cpp 1729 2016-03-30 07:04:48Z stephane $
 */

#include "sg_107020000_Buzzer.hpp"
#include "sg++.hpp"
#include <thread>


SG::Buzzer::~Buzzer( void )
{
	SG::SGpp::get().gpio.gpio_unexport( 2 );	// P9_22 -- GPIO_2

	return;
}


SG::Buzzer::Buzzer( const std::string &n ) :
		GroveGPIO( SG::EGroveType::kBuzzer, n )
{
	SG::SGpp::get().gpio.gpio_export( 2, GpioManagement::EDirection::kOutput );

	return;
}


SG::Buzzer::Buzzer( const SG::Buzzer &rhs ) :
		GroveGPIO( rhs.get_type(), rhs.get_name() )
{
	return;
}


SG::Buzzer &SG::Buzzer::operator=( const SG::Buzzer &rhs )
{
	if (this != &rhs)
	{
		GroveGPIO::operator=( rhs );
	}

	return *this;
}


bool SG::Buzzer::operator==( const SG::Buzzer &rhs ) const
{
	return GroveGPIO::operator==(rhs);
}


SG::Buzzer &SG::Buzzer::turn_off( void )
{
	SG::SGpp::get().gpio.set_low(2);
	std::this_thread::sleep_for( std::chrono::milliseconds(5) );

	return *this;
}


SG::Buzzer &SG::Buzzer::turn_on( void )
{
	SG::SGpp::get().gpio.set_high(2);
	std::this_thread::sleep_for( std::chrono::milliseconds(5) );

	return *this;
}


SG::Buzzer &SG::Buzzer::turn_on( const std::chrono::high_resolution_clock::duration &duration )
{
	// turn on
	SG::SGpp::get().gpio.set_high(2);
	std::this_thread::sleep_for( duration );

	// ...then turn off again
	SG::SGpp::get().gpio.set_low(2);
	std::this_thread::sleep_for( duration );
	
	return *this;
}


SG::Buzzer &SG::Buzzer::turn_off( const std::chrono::high_resolution_clock::duration &duration )
{
	// turn off
	SG::SGpp::get().gpio.set_low(2);
	std::this_thread::sleep_for( duration );

	// ...then turn on again
	SG::SGpp::get().gpio.set_high(2);
	std::this_thread::sleep_for( duration );

	return *this;
}
