/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_107020000_Buzzer.hpp 1729 2016-03-30 07:04:48Z stephane $
 */

#pragma once

#include "sg_GroveGPIO.hpp"
#include <chrono>


namespace SG
{
	/** Audible buzzer.
	 *
	 * Description | Image
	 * ------------|------
	 * %Buzzer connected to the Grove UART interface. | @image html Buzzer_1.jpg
	 *
	 * @see http://www.seeedstudio.com/wiki/Grove_-_Buzzer
	 * @see http://www.seeedstudio.com/depot/Grove-Buzzer-p-768.html
	 */
	class Buzzer : public GroveGPIO
	{
		public:

			/// Destructor.
			virtual ~Buzzer( void );

			/// Constructor.
			Buzzer( const std::string &n="" );

			/// Copy constructor.
			Buzzer( const Buzzer &rhs );

			/// Assignment.
			Buzzer &operator=( const Buzzer &rhs );

			/// Test object equality. @{
			bool operator==( const Buzzer &rhs ) const;
			bool operator!=( const Buzzer &rhs ) const { return ! operator==(rhs); }
			/// @}

			/// Turn the buzzer on.
			Buzzer &turn_on( void );

			/// Turn the buzzer off.
			Buzzer &turn_off( void );

			/** Turn the buzzer on for a limited amount of time, then turn it off again.  This call is synchronous,
			 * and will not return until the buzzer has cycled on then off again.  The duration should be more
			 * than 5 milliseconds, otherwise the buzzer may not behave as expected.
			 */
			Buzzer &turn_on( const std::chrono::high_resolution_clock::duration &duration );

			/** Turn the buzzer off for a limited amount of time, then turn it on again.  This call is synchronous,
			 * and will not return until the buzzer has cycled off then on again.  The duration should be more
			 * than 5 milliseconds, otherwise the buzzer may not behave as expected.
			 */
			Buzzer &turn_off( const std::chrono::high_resolution_clock::duration &duration );
	};
}
