/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_GroveBase.cpp 1512 2016-01-01 09:06:13Z stephane $
 */

#include "sg_GroveBase.hpp"
#include "sg_base.hpp"
#include <typeinfo>


SG::GroveBase::~GroveBase( void )
{
	return;
}


SG::GroveBase::GroveBase( const SG::EGroveType t, const std::string &n ) :
	grove_type( t ),
	grove_name( n )
{
	return;
}


SG::GroveBase::GroveBase( const GroveBase &rhs ) :
	GroveBase( rhs.get_type(), rhs.get_name() )
{
	return;
}


SG::GroveBase &SG::GroveBase::operator=( const GroveBase &rhs )
{
	if (this != &rhs)
	{
		grove_type = rhs.get_type();
		grove_name = rhs.get_name();
	}

	return *this;
}


bool SG::GroveBase::operator==( const GroveBase &rhs ) const
{
	return	get_type() == rhs.get_type() &&
			get_name() == rhs.get_name();
}


std::string	SG::GroveBase::get_description( void ) const
{
	const std::string class_name	= SG::demangle(typeid(*this).name());
	const std::string text_name		= get_name();
	const std::string type_name		= get_type_name();
	const std::string sku			= std::to_string( get_sku() );
	const std::string interface		= (	is_grove_gpio()	? "GPIO"	:
										is_grove_uart()	? "UART"	:
										is_grove_i2c()	? "I2C"		: "" );

	std::string s;
	if (text_name.empty() == false)
	{
		s += text_name + ": ";
	}

	if (interface.empty() == false)
	{
		s += interface + ": ";
	}
	s += class_name + " [SKU #" + sku + "]: " + type_name;

	return s;
}
