/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_groves.cpp 1741 2016-04-06 01:17:28Z stephane $
 */

#include "sg_groves.hpp"
#include "sg_all_groves.hpp"


uint32_t SG::get_sku_from_grove_type( const SG::EGroveType &grove_type )
{
	/// @return zero if the grove type doesn't map to a known Seeed SKU.
	uint32_t sku = 0;

	const uint32_t type = static_cast<uint32_t>(grove_type);

		 if (type >=  4000	and type <  5000)	sku = 101020000 -  4000 + type;
	else if (type >=  5000	and type <  6000)	sku = 103020000 -  5000 + type;
	else if (type >=  6000	and type <  7000)	sku = 104020000 -  6000 + type;
	else if (type >=  7000	and type <  8000)	sku = 104030000 -  7000 + type;
	else if (type >=  8000	and type <  9000)	sku = 105020000 -  8000 + type;
	else if (type >=  9000	and type < 10000)	sku = 107020000 -  9000 + type;
	else if (type >= 10000	and type < 11000)	sku = 111020000 - 10000 + type;
	else if (type >= 11000	and type < 12000)	sku = 113020000 - 11000 + type;
	else if (type == 15000)						sku = 113060000;
	else if (type == 15001)						sku = 316010005;

	return sku;
}


SG::VGroveTypes SG::get_all_grove_types( void )
{
	/* Ugly, but by using a switch statement we can ensure that every type is processed.
	 * (If you forget to add a type, the compiler reports an error about an unhandled case.)
	 */

	VGroveTypes v;
	const EGroveType type = EGroveType::kInvalid;

	switch (type)
	{
		case EGroveType::kInvalid:										v.push_back( EGroveType::kInvalid									);
		case EGroveType::kUnknown:										v.push_back( EGroveType::kUnknown									);
		case EGroveType::kNone:											v.push_back( EGroveType::kNone										);
		case EGroveType::kSerialCameraKit:								v.push_back( EGroveType::kSerialCameraKit							);
		case EGroveType::kHCHOSensor:									v.push_back( EGroveType::kHCHOSensor								);
		case EGroveType::kGasSensorO2:									v.push_back( EGroveType::kGasSensorO2								);
		case EGroveType::kButton:										v.push_back( EGroveType::kButton									);
		case EGroveType::kSwitchP:										v.push_back( EGroveType::kSwitchP									);
		case EGroveType::kCollisionSensor:								v.push_back( EGroveType::kCollisionSensor							);
		case EGroveType::kGasSensorMQ3:									v.push_back( EGroveType::kGasSensorMQ3								);
		case EGroveType::kMiniCamera:									v.push_back( EGroveType::kMiniCamera								);
		case EGroveType::kMoistureSensor:								v.push_back( EGroveType::kMoistureSensor							);
		case EGroveType::kLineFinder:									v.push_back( EGroveType::kLineFinder								);
		case EGroveType::kUltrasonicRanger:								v.push_back( EGroveType::kUltrasonicRanger							);
		case EGroveType::kTemperatureAndHumiditySensor:					v.push_back( EGroveType::kTemperatureAndHumiditySensor				);
		case EGroveType::kDustSensor:									v.push_back( EGroveType::kDustSensor								);
		case EGroveType::kRTC:											v.push_back( EGroveType::kRTC										);
		case EGroveType::kAnalogLightSensor:							v.push_back( EGroveType::kAnalogLightSensor							);
		case EGroveType::kTemperatureSensorV12:							v.push_back( EGroveType::kTemperatureSensorV12						);
		case EGroveType::kInfraredReceiver:								v.push_back( EGroveType::kInfraredReceiver							);
		case EGroveType::kRotaryAngleSensor:							v.push_back( EGroveType::kRotaryAngleSensor							);
		case EGroveType::kWaterSensor:									v.push_back( EGroveType::kWaterSensor								);
		case EGroveType::kTemperatureAndHumiditySensorPro:				v.push_back( EGroveType::kTemperatureAndHumiditySensorPro			);
		case EGroveType::kPIRMotionSensor:								v.push_back( EGroveType::kPIRMotionSensor							);
		case EGroveType::kAirQualitySensor:								v.push_back( EGroveType::kAirQualitySensor							);
		case EGroveType::kAnalogLightSensorP:							v.push_back( EGroveType::kAnalogLightSensorP						);
		case EGroveType::kSoundSensor:									v.push_back( EGroveType::kSoundSensor								);
		case EGroveType::kMegaShield:									v.push_back( EGroveType::kMegaShield								);
		case EGroveType::kTiltSwitch:									v.push_back( EGroveType::kTiltSwitch								);
		case EGroveType::kInfraredEmitter:								v.push_back( EGroveType::kInfraredEmitter							);
		case EGroveType::kElectricitySensor:							v.push_back( EGroveType::kElectricitySensor							);
		case EGroveType::kThumbJoystick:								v.push_back( EGroveType::kThumbJoystick								);
		case EGroveType::kInfraredReflectiveSensor:						v.push_back( EGroveType::kInfraredReflectiveSensor					);
		case EGroveType::kDigitalLightSensor:							v.push_back( EGroveType::kDigitalLightSensor						);
		case EGroveType::kPiezoVibrationSensor:							v.push_back( EGroveType::kPiezoVibrationSensor						);
		case EGroveType::kBarometerSensor:								v.push_back( EGroveType::kBarometerSensor							);
		case EGroveType::kEarClipHeartRateSensor:						v.push_back( EGroveType::kEarClipHeartRateSensor					);
		case EGroveType::k3AxisDigitalCompass:							v.push_back( EGroveType::k3AxisDigitalCompass						);
		case EGroveType::kProtoShield:									v.push_back( EGroveType::kProtoShield								);
		case EGroveType::kSlidePotentiometer:							v.push_back( EGroveType::kSlidePotentiometer						);
		case EGroveType::kTouchSensor:									v.push_back( EGroveType::kTouchSensor								);
		case EGroveType::kMagneticSwitch:								v.push_back( EGroveType::kMagneticSwitch							);
		case EGroveType::k3AxisDigitalAccelerometer1_5g:				v.push_back( EGroveType::k3AxisDigitalAccelerometer1_5g				);
		case EGroveType::kIRDistanceInterrupt:							v.push_back( EGroveType::kIRDistanceInterrupt						);
		case EGroveType::kI2CColorSensor:								v.push_back( EGroveType::kI2CColorSensor							);
		case EGroveType::k80cmInfraredProximitySensor:					v.push_back( EGroveType::k80cmInfraredProximitySensor				);
		case EGroveType::kUVSensor:										v.push_back( EGroveType::kUVSensor									);
		case EGroveType::kAlcoholSensor:								v.push_back( EGroveType::kAlcoholSensor								);
		case EGroveType::kGasSensorMQ9:									v.push_back( EGroveType::kGasSensorMQ9								);
		case EGroveType::kHallSensor:									v.push_back( EGroveType::kHallSensor								);
		case EGroveType::kI2CTouchSensor:								v.push_back( EGroveType::kI2CTouchSensor							);
		case EGroveType::kRotaryAngleSensorP:							v.push_back( EGroveType::kRotaryAngleSensorP						);
		case EGroveType::kFlameSensor:									v.push_back( EGroveType::kFlameSensor								);
		case EGroveType::k3AxisDigitalGyro:								v.push_back( EGroveType::k3AxisDigitalGyro							);
		case EGroveType::k3AxisAnalogAccelerometer:						v.push_back( EGroveType::k3AxisAnalogAccelerometer					);
		case EGroveType::kGSRSensor:									v.push_back( EGroveType::kGSRSensor									);
		case EGroveType::kSingleAxisAnalogGyro:							v.push_back( EGroveType::kSingleAxisAnalogGyro						);
		case EGroveType::k3AxisDigitalAccelerometer16g:					v.push_back( EGroveType::k3AxisDigitalAccelerometer16g				);
		case EGroveType::kGasSensorMQ2:									v.push_back( EGroveType::kGasSensorMQ2								);
		case EGroveType::kGasSensorMQ5:									v.push_back( EGroveType::kGasSensorMQ5								);
		case EGroveType::kFingerprintSensor:							v.push_back( EGroveType::kFingerprintSensor							);
		case EGroveType::kEMGDetector:									v.push_back( EGroveType::kEMGDetector								);
		case EGroveType::kIMU9DOFV1:									v.push_back( EGroveType::kIMU9DOFV1									);
		case EGroveType::kMotionSensorLargeLens:						v.push_back( EGroveType::kMotionSensorLargeLens						);
		case EGroveType::k6AxisAccelerometerAndCompassV1:				v.push_back( EGroveType::k6AxisAccelerometerAndCompassV1			);
		case EGroveType::kAnalogInfraredTemperatureSensor:				v.push_back( EGroveType::kAnalogInfraredTemperatureSensor			);
		case EGroveType::kLoudnessSensor:								v.push_back( EGroveType::kLoudnessSensor							);
		case EGroveType::kSerialCamera:									v.push_back( EGroveType::kSerialCamera								);
		case EGroveType::kPHSensor:										v.push_back( EGroveType::kPHSensor									);
		case EGroveType::kChestStrapHeartRateSensor:					v.push_back( EGroveType::kChestStrapHeartRateSensor					);
		case EGroveType::kCO2Sensor:									v.push_back( EGroveType::kCO2Sensor									);
		case EGroveType::kBarometerHighAccuracy:						v.push_back( EGroveType::kBarometerHighAccuracy						);
		case EGroveType::kQTouchSensor:									v.push_back( EGroveType::kQTouchSensor								);
		case EGroveType::kNFCTag:										v.push_back( EGroveType::kNFCTag									);
		case EGroveType::k3AxisDigitalAccelerometer400g:				v.push_back( EGroveType::k3AxisDigitalAccelerometer400g				);
		case EGroveType::kBarometerSensorBMP180:						v.push_back( EGroveType::kBarometerSensorBMP180						);
		case EGroveType::kElectromagnet:								v.push_back( EGroveType::kElectromagnet								);
		case EGroveType::kTemperatureAndHumidityHighAccuracyAndMini:	v.push_back( EGroveType::kTemperatureAndHumidityHighAccuracyAndMini	);
		case EGroveType::kLuminanceSensor:								v.push_back( EGroveType::kLuminanceSensor							);
		case EGroveType::kDigitalInfraredTemperatureSensor:				v.push_back( EGroveType::kDigitalInfraredTemperatureSensor			);
		case EGroveType::kAirQualitySensorV13:							v.push_back( EGroveType::kAirQualitySensorV13						);
		case EGroveType::kIMU10DOF:										v.push_back( EGroveType::kIMU10DOF									);
		case EGroveType::kIMU9DOFV2:									v.push_back( EGroveType::kIMU9DOFV2									);
		case EGroveType::k6AxisAccelerometerAndCompassV2:				v.push_back( EGroveType::k6AxisAccelerometerAndCompassV2			);
		case EGroveType::kFingerClipHeartRateSensorWithShell:			v.push_back( EGroveType::kFingerClipHeartRateSensorWithShell		);
		case EGroveType::kGestureV1:									v.push_back( EGroveType::kGestureV1									);
		case EGroveType::kTemperatureAndHumiditySensorHDC1000:			v.push_back( EGroveType::kTemperatureAndHumiditySensorHDC1000		);
		case EGroveType::kMultichannelGasSensor:						v.push_back( EGroveType::kMultichannelGasSensor						);
		case EGroveType::kSunlightSensor:								v.push_back( EGroveType::kSunlightSensor							);
		case EGroveType::kWaterAtomization:								v.push_back( EGroveType::kWaterAtomization							);
		case EGroveType::kMiniTrackBall:								v.push_back( EGroveType::kMiniTrackBall								);
		case EGroveType::kDMX512:										v.push_back( EGroveType::kDMX512									);
		case EGroveType::kBeeSocket:									v.push_back( EGroveType::kBeeSocket									);
		case EGroveType::kPS2Adapter:									v.push_back( EGroveType::kPS2Adapter								);
		case EGroveType::kSolidStateRelay:								v.push_back( EGroveType::kSolidStateRelay							);
		case EGroveType::kRelayV12:										v.push_back( EGroveType::kRelayV12									);
		case EGroveType::kI2CHub:										v.push_back( EGroveType::kI2CHub									);
		case EGroveType::kScrewTerminal:								v.push_back( EGroveType::kScrewTerminal								);
		case EGroveType::kMOSFET:										v.push_back( EGroveType::kMOSFET									);
		case EGroveType::kNunChuck:										v.push_back( EGroveType::kNunChuck									);
		case EGroveType::k2CoilLatchingRelay:							v.push_back( EGroveType::k2CoilLatchingRelay						);
		case EGroveType::kRJ45Adapter:									v.push_back( EGroveType::kRJ45Adapter								);
		case EGroveType::kSPDTRelay30A:									v.push_back( EGroveType::kSPDTRelay30A								);
		case EGroveType::kI2CADC:										v.push_back( EGroveType::kI2CADC									);
		case EGroveType::kDryReedRelay:									v.push_back( EGroveType::kDryReedRelay								);
		case EGroveType::kGroveCapeForBeagleBone:						v.push_back( EGroveType::kGroveCapeForBeagleBone					);
		case EGroveType::kDifferentialAmplifierV12:						v.push_back( EGroveType::kDifferentialAmplifierV12					);
		case EGroveType::kRecorder:										v.push_back( EGroveType::kRecorder									);
		case EGroveType::kVoltageDivider:								v.push_back( EGroveType::kVoltageDivider							);
		case EGroveType::kVariableColorLED:								v.push_back( EGroveType::kVariableColorLED							);
		case EGroveType::kPurpleLED:									v.push_back( EGroveType::kPurpleLED									);
		case EGroveType::kBlinkM:										v.push_back( EGroveType::kBlinkM									);
		case EGroveType::kSerialLCD:									v.push_back( EGroveType::kSerialLCD									);
		case EGroveType::kLEDLightString:								v.push_back( EGroveType::kLEDLightString							);
		case EGroveType::kLEDBarV2:										v.push_back( EGroveType::kLEDBarV2									);
		case EGroveType::kLCDRGBBacklight:								v.push_back( EGroveType::kLCDRGBBacklight							);
		case EGroveType::kLEDBar:										v.push_back( EGroveType::kLEDBar									);
		case EGroveType::k4DigitDisplay:								v.push_back( EGroveType::k4DigitDisplay								);
		case EGroveType::kRedLED:										v.push_back( EGroveType::kRedLED									);
		case EGroveType::kChainableRGBLED:								v.push_back( EGroveType::kChainableRGBLED							);
		case EGroveType::kGreenLED:										v.push_back( EGroveType::kGreenLED									);
		case EGroveType::kOLEDDisplay1_12:								v.push_back( EGroveType::kOLEDDisplay1_12							);
		case EGroveType::kWhiteLED:										v.push_back( EGroveType::kWhiteLED									);
		case EGroveType::kBlueLED:										v.push_back( EGroveType::kBlueLED									);
		case EGroveType::kOLEDDisplay0_96:								v.push_back( EGroveType::kOLEDDisplay0_96							);
		case EGroveType::kCircularLED:									v.push_back( EGroveType::kCircularLED								);
		case EGroveType::kMultiColorFlashLED:							v.push_back( EGroveType::kMultiColorFlashLED						);
		case EGroveType::kLED:											v.push_back( EGroveType::kLED										);
		case EGroveType::kI2CMotorDriverV12:							v.push_back( EGroveType::kI2CMotorDriverV12							);
		case EGroveType::kLEDStripDriver:								v.push_back( EGroveType::kLEDStripDriver							);
		case EGroveType::kVibrationMotor:								v.push_back( EGroveType::kVibrationMotor							);
		case EGroveType::kMiniFan:										v.push_back( EGroveType::kMiniFan									);
		case EGroveType::kELDriver:										v.push_back( EGroveType::kELDriver									);
		case EGroveType::kI2CMotorDriverV10:							v.push_back( EGroveType::kI2CMotorDriverV10							);
		case EGroveType::kHapticMotor:									v.push_back( EGroveType::kHapticMotor								);
		case EGroveType::kBuzzer:										v.push_back( EGroveType::kBuzzer									);
		case EGroveType::kSpeaker:										v.push_back( EGroveType::kSpeaker									);
		case EGroveType::kSerialMP3Player:								v.push_back( EGroveType::kSerialMP3Player							);
		case EGroveType::kSoundRecorder:								v.push_back( EGroveType::kSoundRecorder								);
		case EGroveType::kFMReceiver:									v.push_back( EGroveType::kFMReceiver								);
		case EGroveType::kI2CFMReceiver:								v.push_back( EGroveType::kI2CFMReceiver								);
		case EGroveType::kMP3V2:										v.push_back( EGroveType::kMP3V2										);
		case EGroveType::kButtonP:										v.push_back( EGroveType::kButtonP									);
		case EGroveType::kEncoder:										v.push_back( EGroveType::kEncoder									);
		case EGroveType::kHighTemperatureSensor:						v.push_back( EGroveType::kHighTemperatureSensor						);
		case EGroveType::kSerialRFPro:									v.push_back( EGroveType::kSerialRFPro								);
		case EGroveType::k315MHzSimpleRFLinkKit:						v.push_back( EGroveType::k315MHzSimpleRFLinkKit						);
		case EGroveType::k125KHzRFIDReader:								v.push_back( EGroveType::k125KHzRFIDReader							);
		case EGroveType::kGPS:											v.push_back( EGroveType::kGPS										);
		case EGroveType::kXBeeCarrier:									v.push_back( EGroveType::kXBeeCarrier								);
		case EGroveType::kSerialBluetooth:								v.push_back( EGroveType::kSerialBluetooth							);
		case EGroveType::kNFC:											v.push_back( EGroveType::kNFC										);
		case EGroveType::kBLE:											v.push_back( EGroveType::kBLE										);
		case EGroveType::kSerialBluetoothV3:							v.push_back( EGroveType::kSerialBluetoothV3							);
		case EGroveType::kBLEDualModel:									v.push_back( EGroveType::kBLEDualModel								);
		case EGroveType::kUartWifi:										v.push_back( EGroveType::kUartWifi									);
		case EGroveType::k433MHzSimpleRFLinkKit:						v.push_back( EGroveType::k433MHzSimpleRFLinkKit						);
		case EGroveType::kServo:										v.push_back( EGroveType::kServo										);
		// Do *NOT* add a default case to this switch statement!
	}

	return v;
}


SG::MGroveTypeNames SG::get_grove_type_name_map( void )
{
	const VGroveTypes v = get_all_grove_types();

	MGroveTypeNames m;
	for ( const EGroveType grove_type : v )
	{
		// use a switch to ensure we remember to give a name to every type
		switch (grove_type)
		{
			case EGroveType::kInvalid:										m[ grove_type ] = "invalid";											break;
			case EGroveType::kUnknown:										m[ grove_type ] = "unknown";											break;
			case EGroveType::kNone:											m[ grove_type ] = "none";												break;
			case EGroveType::kSerialCameraKit:								m[ grove_type ] = "serial camera kit";									break;
			case EGroveType::kHCHOSensor:									m[ grove_type ] = "HCHO sensor";										break;
			case EGroveType::kGasSensorO2:									m[ grove_type ] = "gas sensor";											break;
			case EGroveType::kButton:										m[ grove_type ] = "button";												break;
			case EGroveType::kSwitchP:										m[ grove_type ] = "switch";												break;
			case EGroveType::kCollisionSensor:								m[ grove_type ] = "collision sensor";									break;
			case EGroveType::kGasSensorMQ3:									m[ grove_type ] = "gas sensor";											break;
			case EGroveType::kMiniCamera:									m[ grove_type ] = "mini camera";										break;
			case EGroveType::kMoistureSensor:								m[ grove_type ] = "moisture sensor";									break;
			case EGroveType::kLineFinder:									m[ grove_type ] = "line finder";										break;
			case EGroveType::kUltrasonicRanger:								m[ grove_type ] = "ultrasonic ranger";									break;
			case EGroveType::kTemperatureAndHumiditySensor:					m[ grove_type ] = "temperature and humidity sensor";					break;
			case EGroveType::kDustSensor:									m[ grove_type ] = "dust sensor";										break;
			case EGroveType::kRTC:											m[ grove_type ] = "RTC";												break;
			case EGroveType::kAnalogLightSensor:							m[ grove_type ] = "analog light sensor";								break;
			case EGroveType::kTemperatureSensorV12:							m[ grove_type ] = "temperature sensor";									break;
			case EGroveType::kInfraredReceiver:								m[ grove_type ] = "infrared receiver";									break;
			case EGroveType::kRotaryAngleSensor:							m[ grove_type ] = "rotary angle sensor";								break;
			case EGroveType::kWaterSensor:									m[ grove_type ] = "water sensor";										break;
			case EGroveType::kTemperatureAndHumiditySensorPro:				m[ grove_type ] = "temperature and humidity sensor";					break;
			case EGroveType::kPIRMotionSensor:								m[ grove_type ] = "PIR motion sensor";									break;
			case EGroveType::kAirQualitySensor:								m[ grove_type ] = "air quality sensor";									break;
			case EGroveType::kAnalogLightSensorP:							m[ grove_type ] = "analog light sensor";								break;
			case EGroveType::kSoundSensor:									m[ grove_type ] = "sound sensor";										break;
			case EGroveType::kMegaShield:									m[ grove_type ] = "mega shield";										break;
			case EGroveType::kTiltSwitch:									m[ grove_type ] = "tilt switch";										break;
			case EGroveType::kInfraredEmitter:								m[ grove_type ] = "infrared emitter";									break;
			case EGroveType::kElectricitySensor:							m[ grove_type ] = "electricity sensor";									break;
			case EGroveType::kThumbJoystick:								m[ grove_type ] = "thumb joystick";										break;
			case EGroveType::kInfraredReflectiveSensor:						m[ grove_type ] = "infrared reflective sensor";							break;
			case EGroveType::kDigitalLightSensor:							m[ grove_type ] = "digital light sensor";								break;
			case EGroveType::kPiezoVibrationSensor:							m[ grove_type ] = "Piezo vibration sensor";								break;
			case EGroveType::kBarometerSensor:								m[ grove_type ] = "barometer sensor";									break;
			case EGroveType::kEarClipHeartRateSensor:						m[ grove_type ] = "ear clip heart rate sensor";							break;
			case EGroveType::k3AxisDigitalCompass:							m[ grove_type ] = "3-axis digital compass";								break;
			case EGroveType::kProtoShield:									m[ grove_type ] = "proto shield";										break;
			case EGroveType::kSlidePotentiometer:							m[ grove_type ] = "slide potentiometer";								break;
			case EGroveType::kTouchSensor:									m[ grove_type ] = "touch sensor";										break;
			case EGroveType::kMagneticSwitch:								m[ grove_type ] = "magnetic switch";									break;
			case EGroveType::k3AxisDigitalAccelerometer1_5g:				m[ grove_type ] = "3-axis digital accelerometer";						break;
			case EGroveType::kIRDistanceInterrupt:							m[ grove_type ] = "IR distance interrupt";								break;
			case EGroveType::kI2CColorSensor:								m[ grove_type ] = "color sensor";										break;
			case EGroveType::k80cmInfraredProximitySensor:					m[ grove_type ] = "infrared proximity sensor";							break;
			case EGroveType::kUVSensor:										m[ grove_type ] = "UV sensor";											break;
			case EGroveType::kAlcoholSensor:								m[ grove_type ] = "alcohol sensor";										break;
			case EGroveType::kGasSensorMQ9:									m[ grove_type ] = "gas sensor";											break;
			case EGroveType::kHallSensor:									m[ grove_type ] = "hall sensor";										break;
			case EGroveType::kI2CTouchSensor:								m[ grove_type ] = "touch sensor";										break;
			case EGroveType::kRotaryAngleSensorP:							m[ grove_type ] = "rotary angle sensor";								break;
			case EGroveType::kFlameSensor:									m[ grove_type ] = "flame sensor";										break;
			case EGroveType::k3AxisDigitalGyro:								m[ grove_type ] = "3-axis digital gyro";								break;
			case EGroveType::k3AxisAnalogAccelerometer:						m[ grove_type ] = "3-axis analog accelerometer";						break;
			case EGroveType::kGSRSensor:									m[ grove_type ] = "GSR sensor";											break;
			case EGroveType::kSingleAxisAnalogGyro:							m[ grove_type ] = "single axis analog gyro";							break;
			case EGroveType::k3AxisDigitalAccelerometer16g:					m[ grove_type ] = "3-axis digital accelerometer";						break;
			case EGroveType::kGasSensorMQ2:									m[ grove_type ] = "gas sensor";											break;
			case EGroveType::kGasSensorMQ5:									m[ grove_type ] = "gas sensor";											break;
			case EGroveType::kFingerprintSensor:							m[ grove_type ] = "fingerprint sensor";									break;
			case EGroveType::kEMGDetector:									m[ grove_type ] = "EMG detector";										break;
			case EGroveType::kIMU9DOFV1:									m[ grove_type ] = "IMU9DOF";											break;
			case EGroveType::kMotionSensorLargeLens:						m[ grove_type ] = "motion sensor with large lens";						break;
			case EGroveType::k6AxisAccelerometerAndCompassV1:				m[ grove_type ] = "6-axis accelerometer and compass";					break;
			case EGroveType::kAnalogInfraredTemperatureSensor:				m[ grove_type ] = "analog infrared temperature sensor";					break;
			case EGroveType::kLoudnessSensor:								m[ grove_type ] = "loudness sensor";									break;
			case EGroveType::kSerialCamera:									m[ grove_type ] = "serial camera";										break;
			case EGroveType::kPHSensor:										m[ grove_type ] = "PH sensor";											break;
			case EGroveType::kChestStrapHeartRateSensor:					m[ grove_type ] = "chest strap heart rate sensor";						break;
			case EGroveType::kCO2Sensor:									m[ grove_type ] = "CO2 sensor";											break;
			case EGroveType::kBarometerHighAccuracy:						m[ grove_type ] = "barometer";											break;
			case EGroveType::kQTouchSensor:									m[ grove_type ] = "Q Touch sensor";										break;
			case EGroveType::kNFCTag:										m[ grove_type ] = "NFC tag";											break;
			case EGroveType::k3AxisDigitalAccelerometer400g:				m[ grove_type ] = "3-axis digital accelerometer";						break;
			case EGroveType::kBarometerSensorBMP180:						m[ grove_type ] = "barometer senson BMP180";							break;
			case EGroveType::kElectromagnet:								m[ grove_type ] = "electromagnet";										break;
			case EGroveType::kTemperatureAndHumidityHighAccuracyAndMini:	m[ grove_type ] = "temperature and humidity high accuracy and mini";	break;
			case EGroveType::kLuminanceSensor:								m[ grove_type ] = "luminance sensor";									break;
			case EGroveType::kDigitalInfraredTemperatureSensor:				m[ grove_type ] = "digital infrared temperature sensor";				break;
			case EGroveType::kAirQualitySensorV13:							m[ grove_type ] = "air quality sensor";									break;
			case EGroveType::kIMU10DOF:										m[ grove_type ] = "IMU10DOF";											break;
			case EGroveType::kIMU9DOFV2:									m[ grove_type ] = "IMU9DOF";											break;
			case EGroveType::k6AxisAccelerometerAndCompassV2:				m[ grove_type ] = "6-axis accelerometer and compass";					break;
			case EGroveType::kFingerClipHeartRateSensorWithShell:			m[ grove_type ] = "finger clip heart rate sensor";						break;
			case EGroveType::kGestureV1:									m[ grove_type ] = "gesture";											break;
			case EGroveType::kTemperatureAndHumiditySensorHDC1000:			m[ grove_type ] = "temperature and humidity sensor";					break;
			case EGroveType::kMultichannelGasSensor:						m[ grove_type ] = "multichannel gas sensor";							break;
			case EGroveType::kSunlightSensor:								m[ grove_type ] = "sunlight sensor";									break;
			case EGroveType::kWaterAtomization:								m[ grove_type ] = "water atomization";									break;
			case EGroveType::kMiniTrackBall:								m[ grove_type ] = "mini trackball";										break;
			case EGroveType::kDMX512:										m[ grove_type ] = "DMX512";												break;
			case EGroveType::kBeeSocket:									m[ grove_type ] = "Bee socket";											break;
			case EGroveType::kPS2Adapter:									m[ grove_type ] = "PS/2 adapter";										break;
			case EGroveType::kSolidStateRelay:								m[ grove_type ] = "solid state relay";									break;
			case EGroveType::kRelayV12:										m[ grove_type ] = "relay";												break;
			case EGroveType::kI2CHub:										m[ grove_type ] = "I2C hub";											break;
			case EGroveType::kScrewTerminal:								m[ grove_type ] = "screw terminal";										break;
			case EGroveType::kMOSFET:										m[ grove_type ] = "MOSFET";												break;
			case EGroveType::kNunChuck:										m[ grove_type ] = "nunchuck";											break;
			case EGroveType::k2CoilLatchingRelay:							m[ grove_type ] = "coil latching relay";								break;
			case EGroveType::kRJ45Adapter:									m[ grove_type ] = "RJ45 adapter";										break;
			case EGroveType::kSPDTRelay30A:									m[ grove_type ] = "SPDT relay 30A";										break;
			case EGroveType::kI2CADC:										m[ grove_type ] = "ADC";												break;
			case EGroveType::kDryReedRelay:									m[ grove_type ] = "dry reed relay";										break;
			case EGroveType::kGroveCapeForBeagleBone:						m[ grove_type ] = "Grove cape for BeagleBone";							break;
			case EGroveType::kDifferentialAmplifierV12:						m[ grove_type ] = "differential amplifier";								break;
			case EGroveType::kRecorder:										m[ grove_type ] = "recorder";											break;
			case EGroveType::kVoltageDivider:								m[ grove_type ] = "voltage divider";									break;
			case EGroveType::kVariableColorLED:								m[ grove_type ] = "variable color LED";									break;
			case EGroveType::kPurpleLED:									m[ grove_type ] = "purple LED";											break;
			case EGroveType::kBlinkM:										m[ grove_type ] = "BlinkM";												break;
			case EGroveType::kSerialLCD:									m[ grove_type ] = "serial LCD";											break;
			case EGroveType::kLEDLightString:								m[ grove_type ] = "LED light string";									break;
			case EGroveType::kLEDBarV2:										m[ grove_type ] = "LED bar";											break;
			case EGroveType::kLCDRGBBacklight:								m[ grove_type ] = "LCD RGB backlight";									break;
			case EGroveType::kLEDBar:										m[ grove_type ] = "LED bar";											break;
			case EGroveType::k4DigitDisplay:								m[ grove_type ] = "4-digit display";									break;
			case EGroveType::kRedLED:										m[ grove_type ] = "red LED";											break;
			case EGroveType::kChainableRGBLED:								m[ grove_type ] = "chainable RGB LED";									break;
			case EGroveType::kGreenLED:										m[ grove_type ] = "green LED";											break;
			case EGroveType::kOLEDDisplay1_12:								m[ grove_type ] = "OLED display 1.12\" (128x64)";						break;
			case EGroveType::kWhiteLED:										m[ grove_type ] = "white LED";											break;
			case EGroveType::kBlueLED:										m[ grove_type ] = "blue LED";											break;
			case EGroveType::kOLEDDisplay0_96:								m[ grove_type ] = "OLED display 0.96\"";								break;
			case EGroveType::kCircularLED:									m[ grove_type ] = "circular LED";										break;
			case EGroveType::kMultiColorFlashLED:							m[ grove_type ] = "multi-color flash LED";								break;
			case EGroveType::kLED:											m[ grove_type ] = "LED";												break;
			case EGroveType::kI2CMotorDriverV12:							m[ grove_type ] = "motor driver";										break;
			case EGroveType::kLEDStripDriver:								m[ grove_type ] = "LED strip driver";									break;
			case EGroveType::kVibrationMotor:								m[ grove_type ] = "vibration motor";									break;
			case EGroveType::kMiniFan:										m[ grove_type ] = "mini fan";											break;
			case EGroveType::kELDriver:										m[ grove_type ] = "EL driver";											break;
			case EGroveType::kI2CMotorDriverV10:							m[ grove_type ] = "motor driver";										break;
			case EGroveType::kHapticMotor:									m[ grove_type ] = "haptic motor";										break;
			case EGroveType::kBuzzer:										m[ grove_type ] = "buzzer";												break;
			case EGroveType::kSpeaker:										m[ grove_type ] = "speaker";											break;
			case EGroveType::kSerialMP3Player:								m[ grove_type ] = "serial MP3 player";									break;
			case EGroveType::kSoundRecorder:								m[ grove_type ] = "sound recorder";										break;
			case EGroveType::kFMReceiver:									m[ grove_type ] = "sound recorder";										break;
			case EGroveType::kI2CFMReceiver:								m[ grove_type ] = "FM receiver";										break;
			case EGroveType::kMP3V2:										m[ grove_type ] = "MP3 player";											break;
			case EGroveType::kButtonP:										m[ grove_type ] = "button";												break;
			case EGroveType::kEncoder:										m[ grove_type ] = "encoder";											break;
			case EGroveType::kHighTemperatureSensor:						m[ grove_type ] = "high temperature sensor";							break;
			case EGroveType::kSerialRFPro:									m[ grove_type ] = "serial RF pro";										break;
			case EGroveType::k315MHzSimpleRFLinkKit:						m[ grove_type ] = "315 MHz simple RF link kit";							break;
			case EGroveType::k125KHzRFIDReader:								m[ grove_type ] = "125 KHz RFID reader";								break;
			case EGroveType::kGPS:											m[ grove_type ] = "GPS";												break;
			case EGroveType::kXBeeCarrier:									m[ grove_type ] = "XBee carrier";										break;
			case EGroveType::kSerialBluetooth:								m[ grove_type ] = "serial bluetooth";									break;
			case EGroveType::kNFC:											m[ grove_type ] = "NFC";												break;
			case EGroveType::kBLE:											m[ grove_type ] = "BLE";												break;
			case EGroveType::kSerialBluetoothV3:							m[ grove_type ] = "serial bluetooth";									break;
			case EGroveType::kBLEDualModel:									m[ grove_type ] = "BLE dual model";										break;
			case EGroveType::kUartWifi:										m[ grove_type ] = "UART WIFI";											break;
			case EGroveType::k433MHzSimpleRFLinkKit:						m[ grove_type ] = "433 MHz simple RF link kit";							break;
			case EGroveType::kServo:										m[ grove_type ] = "servo";												break;
			// Do *NOT* add a default case to this switch statement!
		}
	}

	return m;
}


std::string SG::to_string( const SG::EGroveType &type )
{
	const MGroveTypeNames m = get_grove_type_name_map();
	if (m.count(type))
	{
		return m.at(type);
	}

	return "?";
}


SG::VGroveTypes SG::detect( void )
{
	VGroveTypes v;

	return v;
}
