/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_Monospace.cpp 1776 2016-04-17 04:52:34Z stephane $
 */

#include "sg_Monospace.hpp"
#include <ctype.h>


SG::Font::Monospace::Monospace(void)
{
	return;
}


SG::Font::Monospace::~Monospace(void)
{
	return;
}


SG::Font::Monospace::Bitmap SG::Font::Monospace::get(char c, const Fontmap &font_map) const
{
	const auto end = font_map.end();

	if (font_map.find(c) != end)
	{
		return font_map.at(c);
	}

	// if we failed to find the exact character, try the uppercase/lowercase version to see if we have something similar

	const char u = std::toupper(c);
	if (font_map.find(u) != end)
	{
		return font_map.at(u);
	}

	const char l = std::tolower(c);
	if (font_map.find(l) != end)
	{
		return font_map.at(l);
	}

	// we really don't have a character for this, so send back an empty "space" instead
	if (font_map.find(' ') != end)
	{
		return font_map.at(' ');
	}

	// something is wrong if we don't even have 0x20 (space)...send back the first bitmap
	if (font_map.empty() == false)
	{
		return font_map.begin()->second;
	}

	// font map is completely empty -- we should never get here

	/// @throw std::invalid_argument if the character isn't available in the given font.
	throw std::invalid_argument( "SG font " + get_name() + " does not contain character #" + std::to_string( (int) c ) );
}
