/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_104030001_LCDRGBBacklight.hpp 1886 2016-06-01 05:35:45Z stephane $
 */

#pragma once

#include "sg_GroveI2CDigital.hpp"


namespace SG
{
	/** LCD RGB backlight.
	 * 
	 * Description							| Image
	 * -------------------------------------|------
	 * LCD RGB backlight connected to BBG.	| @image html sg_101030001_LCDRGBBacklight.jpg
	 *
	 * Connect the LCD RGB backlight to the left-hand-side digital I2C interface.  There are several I2C addresses for
	 * this device:  @p 0x3e, @p 0x62, @p 0x70.
	 *
	 * ~~~~
	 * i2cdetect -y -r 2
	 *
	 *      0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f
	 * 00:          -- -- -- -- -- *-- -- -- -- -- -- -- -- 
	 * 10: -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
	 * 20: -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
	 * 30: -- -- -- -- -- -- -- -- -- -- -- -- -- -- 3e -- 
	 * 40: -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
	 * 50: -- -- -- -- UU UU UU UU -- -- -- -- -- -- -- -- 
	 * 60: -- -- 62 -- -- -- -- -- -- -- -- -- -- -- -- -- 
	 * 70: 70 -- -- -- -- -- -- -- 
	 * ~~~~
	 *
	 * I2C Address	| Description									| Source
	 * -------------|-----------------------------------------------|-------
	 * @p 0x3e		| JHD1214 LCD module, 16 characters x 2 lines	| JHD1214 data sheet, section 8, page 12
	 * @p 0x62		| PCA9633 LED regular I2C-bus slave address		| PCA9633 data sheet, section 7.1.1, page 8
	 * @p 0x70		| PCA9633 LED All Call address					| PCA9633 data sheet, section 7.1.1, page 8
	 *
	 * @see http://www.seeedstudio.com/item_detail.html?p_id=1643
	 * @see http://www.seeedstudio.com/wiki/Grove_-_LCD_RGB_Backlight
	 * @see http://www.seeedstudio.com/wiki/images/0/03/JHD1214Y_YG_1.0.pdf
	 * @see http://www.seeedstudio.com/wiki/images/1/1c/PCA9633.pdf
	 */
	class LCDRGBBacklight : public GroveI2CDigital
	{
		public:

			/// I2C registers.  @see PCA9633 datasheet page 11
			enum class ERegister
			{
				kModeReg1		= 0,
				kModeReg2		= 1,
				kBrightLED0		= 2,
				kBrightLED1		= 3,
				kBrightLED2		= 4,
				kBrightLED3		= 5,
				kGroupDutyCycle	= 6,
				kGroupFrequency	= 7,
				kLEDOutputState	= 8,
				kI2CBusSubAddr1	= 9,
				kI2CBusSubAddr2	= 10,
				kI2CBusSubAddr3	= 11,
				kLEDAllCallAddr	= 12
			};

/// @todo LCDRGBBacklight work in progress
#if 0
			virtual ~LCDRGBBacklight( void );
			LCDRGBBacklight( void );

			virtual LCDRGBBacklight &reset( void );
			virtual LCDRGBBacklight &set_mode_1( void );
			virtual LCDRGBBacklight &set_mode_2( void );
#endif
	};
}
