/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: names.cpp 1512 2016-01-01 09:06:13Z stephane $
 */

#include "sg++.hpp"
#include <gtest/gtest.h>


TEST( SG, names )
{
	SG::MGroveTypeNames m	= SG::get_grove_type_name_map();
	const std::string n1	= SG::to_string( SG::EGroveType::kGasSensorMQ2 );
	const std::string n2	= m.at( SG::EGroveType::kGasSensorMQ2 );

	ASSERT_STREQ( "gas sensor", n1								.c_str() );
	ASSERT_STREQ( "gas sensor", n2								.c_str() );
	ASSERT_STREQ( "gas sensor", m[SG::EGroveType::kGasSensorMQ2].c_str() );

	// we expect there to be about 120 grove types (2015-12-14)
	ASSERT_GT( m.size(), 100 );
	ASSERT_LT( m.size(), 200 );
}


TEST( SG, count )
{
	const SG::VGroveTypes		v = SG::get_all_grove_types();
	const SG::MGroveTypeNames	m = SG::get_grove_type_name_map();

	// there should be exactly the same number of names as there are types in the vector
	ASSERT_EQ( v.size(), m.size() );
}
