#!/bin/bash
# C Code Run (C) 2016-2017 Stephane Charette <stephanecharette@gmail.com>
# $Id: ccr_misc.sh 2206 2017-04-16 08:26:38Z stephane $
#
# https://www.ccoderun.ca/bbtools/
#
# Various unrelated fixes and changes.


# must be root to make these changes
if (( EUID != 0 )); then
	logger --id --priority user.error --stderr "$0: must run as root"
	exit 1
fi

# unfortunately, the machine-id on Beaglebone devices running RCN's builds are not unique (reported April 2017)
mkdir -p /opt/ccr/files
if [ ! -e /opt/ccr/files/machine_id_created ]; then
	# we cannot trust the default machine id, so create a new one
	logger -id --priority user.info --stderr "$0: machine-id was set to $(dbus-uuidgen --get)"
	rm -f /var/lib/dbus/machine-id
	rm -f /etc/machine-id
	dbus-uuidgen --ensure
	systemd-machine-id-setup
	logger -id --priority user.info --stderr "$0: generated new machine-id $(dbus-uuidgen --get)"
	dbus-uuidgen --get > /opt/ccr/files/machine_id_created
	# force a new hostname to be generated
	rm -f /opt/ccr/files/hostname.ccr
	if [ -x /usr/bin/ccr_hostname.sh ]; then
		ccr_hostname.sh
	fi
fi

# Some packages may have been deleted, but weren't purged.  This will get rid of them completely.
dpkg --list | grep "^rc" | cut -d' ' -f 3 | xargs --no-run-if-empty dpkg --purge


# rsyslog tries to write messages out to /dev/xconsole which we don't have.  This generates periodic messages logged
# to syslog about "action X suspended".  Removing those rsyslog configuration lines that cause these errors and
# restarting rsyslog will solve this problem.
if [ -e /etc/rsyslog.conf ]; then
	grep --quiet "/dev/xconsole" /etc/rsyslog.conf
	if [ $? -eq 0 ]; then
		sed --in-place '/# The named pipe \/dev\/xconsole/,$d' /etc/rsyslog.conf
		service rsyslog restart
	fi
fi


# stop and disable the services we don't need
systemctl stop    avahi-daemon.service avahi-daemon.socket
systemctl disable avahi-daemon.service avahi-daemon.socket


exit 0
