#!/bin/bash -e
# C Code Run (C) 2016-2017 Stephane Charette <stephanecharette@gmail.com>
# $Id: ccr_misc.sh 2087 2017-01-10 18:32:41Z stephane $
#
# https://www.ccoderun.ca/bbtools/
#
# Remove several miscellaneous packages from BB.


# must be root to make these changes
if (( EUID != 0 )); then
	logger --id --priority user.error --stderr "$0: must run as root"
	exit 1
fi


# get a list of packages to remove
packages="$(dpkg -l | cut -f3 -d' ' | grep --extended-regexp 'doc|bone101|c9-core|bb-node|nodejs')"
number_of_packages="$(echo "${packages}" | wc --lines)"

if [ ${number_of_packages} -eq 0 ]; then
	echo "Nothing to remove."
	exit 1
fi

echo ""
echo "${number_of_packages} packages are marked to be removed.  Please review this list carefully!  Other packages that depend on these will be removed as well.  The initial list of packages to remove is:"
list=""
for name in ${packages}; do
	echo "	- ${name}"
	list="${list} ${name}"
done
read -p "Are you sure you want to remove these packages?  " -n 1 -r
echo ""
if [[ $REPLY =~ ^[Yy]$ ]]; then
	logger --id --priority user.info --stderr "$0: removing other miscellaneous packages from device"
	echo "This will take a moment..."
	apt-get --yes purge --auto-remove ${list}
	apt-get --yes autoclean
	apt-get --yes autoremove
	apt-get --yes clean
	apt-get --yes --fix-broken install
	dpkg --list | grep "^rc" | cut -d " " -f 3 | xargs -r sudo dpkg --purge

	echo "Removing other related files which weren't automatically purged with apt-get."
	rm -rf /var/cache/doc-beaglebone-getting-started
	rm -rf /var/lib/cloud9
	rm -rf /var/lib/node_modules
	rm -rf /usr/local/lib/node_modules
	rm -rf /root/.npm
	rm -rf /root/.node
	rm -rf /root/.node-red
	rm -rf /root/.node-gyp
	rm -rf /root/.c9
fi


exit 0
