#!/bin/bash -e
# C Code Run (C) 2016-2017 Stephane Charette <stephanecharette@gmail.com>
# $Id: ccr_misc.sh 2087 2017-01-10 18:32:41Z stephane $
#
# https://www.ccoderun.ca/bbtools/
#
# Remove X-Windows from BB.


# must be root to make these changes
if (( EUID != 0 )); then
	logger --id --priority user.error --stderr "$0: must run as root"
	exit 1
fi


# get a list of all packages related to x11
packages="$(dpkg -l | cut -f3 -d' ' | grep --extended-regexp 'x11|lxqt|xorg|lightdm|gnome|desktop|gnuplot|desktop-file-utils|dsptop|fbset|glib-networking|keyboard-configuration|libaacs0|cairo|libdrm|libfile|libfm|libgoa|gphoto|streamer|libgtk|libpango|libqt|libsoup|libtiff|wayland|policykit')"
number_of_packages="$(echo "${packages}" | wc --lines)"

if [ ${number_of_packages} -eq 0 ]; then
	echo "Failed to find packages to remove."
	exit 1
fi

echo ""
echo "${number_of_packages} packages were identified to be removed.  Other packages that depend on these will be removed as well.  The initial list of packages to remove is:"
list=""
for name in ${packages}; do
	echo "	- ${name}"
	list="${list} ${name}"
done
read -p "Are you sure you want to remove X?  " -n 1 -r
echo ""
if [[ $REPLY =~ ^[Yy]$ ]]; then
	logger --id --priority user.info --stderr "$0: removing all X packages from device"
	echo "This will take a moment..."
	service lightdm stop || true
	apt-get --yes purge --auto-remove ${list}
	apt-get --yes autoclean
	apt-get --yes autoremove
	apt-get --yes clean
	apt-get --yes --fix-broken install
	dpkg --list | grep "^rc" | cut -d " " -f 3 | xargs -r sudo dpkg --purge
fi


exit 0
