#!/bin/bash
# C Code Run (C) 2016-2017 Stephane Charette <stephanecharette@gmail.com>
# $Id: ccr_wifi_power_mode.sh 2116 2017-01-18 13:13:47Z stephane $
#
# https://www.ccoderun.ca/bbtools/
#
# Attempt to set the wifi adapter's power mode.
# Will retry multiple times if the adapter is not up yet.


# must be root to change the wifi adapter
if (( EUID != 0 )); then
	logger --id --priority user.error --stderr "$0: must be root to change the wifi adapter power mode"
	exit 1
fi


filename="/sys/kernel/debug/ieee80211/phy0/wlcore/sleep_auth"
# 0 = active power
# 1 = low power
# 2 = extreme low power (default value)
new_value=0


# try several times to see if this device has a wifi adapter
has_wifi=0
for i in {1..5}
do
	iwconfig 2>/dev/null | grep --quiet "802.11"
	if [ $? -eq 0 ]; then
		has_wifi=1
		break;
	fi
	# try again
	sleep 30
done

if [ ${has_wifi} = 0 ]; then
	# looks like this device does NOT have a wifi adapter
	logger --id --priority user.warning --stderr "$0: wifi adapter not detected"
	exit 0
fi


if [ ! -e "${filename}" ]; then
	logger --id --priority user.warning --stderr "$0: wifi adapter's sleep_auth file not yet available: ${filename}"
else
	old_value="$(cat ${filename})"
	logger --id --priority user.notice --stderr "$0: changing wifi adapter's sleep_auth from ${old_value} to ${new_value} in ${filename}"
	echo ${new_value} > ${filename}
	# we're done
	exit 0
fi

# wait a short period of time before we try again
sleep 30

# restart the script (in case a new version was installed)
exec $0
