/* JPEGWrap (C) 2017 Stephane Charette <stephanecharette@gmail.com>
 * $Id: JW.cpp 2139 2017-02-02 11:17:46Z stephane $
 */

#include "JW.hpp"
#include <stdexcept>
#include <cstring>
#define ZERO(x) std::memset( &x, '\0', sizeof x )


JW::JW( void ) :
	jerr_ptr	( &jerr		),
	cinfo_ptr	( nullptr	),
	dinfo_ptr	( nullptr	),
	file		( nullptr	)
{
	ZERO(jerr);

	return;
}


JW::~JW( void )
{
	if ( file )
	{
		fclose( file );
		file = nullptr;
		fname = "";
	}

	return;
}


JW &JW::set_file( const std::string &filename )
{
	if (file != nullptr)
	{
		fclose( file );
		file = nullptr;
	}

	FILE * f = fopen( filename.c_str(), "wb" );
	if (f == nullptr)
	{
		/// @exception std::runtime_error if the named file cannot be opened
		throw std::runtime_error( "failed to open \"" + filename + "\"" );
	}

	set_file(f);
	fname = filename;

	return *this;
}


JW &JW::set_file( FILE * f )
{
	if (f == nullptr)
	{
		/// @exception std::runtime_error if the file pointer is null
		throw std::runtime_error( "cannot set null file pointer" );
	}

	if (file != nullptr)
	{
		if (f != file)
		{
			fclose( file );
		}
	}

	file = f;
	fname = "";

	if (cinfo_ptr)	jpeg_stdio_dest	( cinfo_ptr, file );
	if (dinfo_ptr)	jpeg_stdio_src	( dinfo_ptr, file );

	return *this;
}
