# CamCap (C) 2017 Stephane Charette <stephanecharette@gmail.com>
# $Id: CM_definitions.cmake 2562 2018-07-19 08:57:49Z stephane $


SET ( CMAKE_CXX_STANDARD 11 )
SET ( CMAKE_CXX_STANDARD_REQUIRED ON )

ADD_DEFINITIONS ( "-Wall -Wextra -Werror -Wno-unused-parameter" )
ADD_DEFINITIONS ( "-DCAMCAP_VER=\"${CAMCAP_VERSION}\"" )

IF ( CMAKE_SIZEOF_VOID_P EQUAL 8 )
	SET ( CAMCAP_BIT_SIZE 64 )
ELSEIF ( CMAKE_SIZEOF_VOID_P EQUAL 4 )
	SET ( CAMCAP_BIT_SIZE 32 )
ELSE ()
	MESSAGE ( FATAL_ERROR "CMAKE_SIZEOF_VOID_P=${CMAKE_SIZEOF_VOID_P}" )
ENDIF ()

STRING (FIND "${CMAKE_CXX_COMPILER}" "arm-linux-gnueabihf-g++" pos)
IF ( ${pos} EQUAL -1 )
	SET ( CAMCAP_CROSS_COMPILE_FOR_ARM7 FALSE )
ELSE ()
	MESSAGE ( "Cross compiling for ARM7" )
	SET ( CAMCAP_CROSS_COMPILE_FOR_ARM7 TRUE )
ENDIF ()


STRING (FIND "${CMAKE_SYSTEM_PROCESSOR}" "arm" pos)
IF ( ${pos} EQUAL -1 )
	SET ( CAMCAP_COMPILE_FOR_ARM7 FALSE )
ELSE ()
	MESSAGE ( "Compiling for ARM" )
	SET ( CAMCAP_COMPILE_FOR_ARM7 TRUE )
ENDIF ()


IF ( ${CAMCAP_CROSS_COMPILE_FOR_ARM7} OR ${CAMCAP_COMPILE_FOR_ARM7} )
	SET ( CAMCAP_SYSTEM_NAME "armhf-${CAMCAP_BIT_SIZE}" )
ELSE ()
	IF ( CAMCAP_BIT_SIZE EQUAL 32 )
		SET ( CAMCAP_SYSTEM_NAME "x86-${CAMCAP_BIT_SIZE}" )
	ELSE ()
		SET ( CAMCAP_SYSTEM_NAME "amd-${CAMCAP_BIT_SIZE}" )
	ENDIF ()
ENDIF ()
