/* CamCap (C) 2017 Stephane Charette <stephanecharette@gmail.com>
 * $Id: CamCap_CC.cpp 2562 2018-07-19 08:57:49Z stephane $
 */

/** @file
 * Functions in the %CC namespace.
 */

#include "CamCap.hpp"
#include "CamCap_defines.h"
#include <arpa/inet.h>
#include <netinet/in.h>


CC::BufferDetail::BufferDetail( void )
{
	ZERO( buffer );
	address = nullptr;
	return;
}


CC::CaptureAndBuffer::CaptureAndBuffer( void )
{
	ZERO( info );
	return;
}


std::string CC::fourcc_to_string( uint32_t fcc )
{
	fcc = ntohl(fcc);

	char text[5];
	text[0] = (fcc >> 24) & 0xff;
	text[1] = (fcc >> 16) & 0xff;
	text[2] = (fcc >>  8) & 0xff;
	text[3] = (fcc >>  0) & 0xff;
	text[4] = '\0';

	return text;
}


uint32_t CC::gcd( uint32_t u, uint32_t v )
{
	// Binary gcd algorithm
	// Public domain:  https://gist.github.com/cslarsen/1635213

	int shift_left = 0;

	while ( u && v && u!=v )
	{
		const bool u_is_even = !(u & 1);
		const bool v_is_even = !(v & 1);

		if ( u_is_even && v_is_even )
		{
			shift_left ++;
			u >>= 1;
			v >>= 1;
		}
		else if ( u_is_even && !v_is_even ) u >>= 1;
		else if ( !u_is_even && v_is_even ) v >>= 1;
		else if ( u >= v ) u = (u - v) >> 1;
		else
		{
			auto tmp = u;
			u = (v - u) >> 1;
			v = tmp;
		}
	}

	return !u? v << shift_left : u << shift_left;
}


std::string CC::get_version( void )
{
	return CAMCAP_VER;
}
