/* CamCap (C) 2017 Stephane Charette <stephanecharette@gmail.com>
 * $Id: CamCap_defines.h 2159 2017-02-18 21:12:16Z stephane $
 */

#pragma once

/** @file
 * Internal definitions and macros that are used in the CamCap source code.
 */

#include <cstring>
#include <libv4l2.h>

/// Zero out the given structure.
#define ZERO(x) std::memset( &x, '\0', sizeof x)

// Several V4L2 defines missing from older versions of libv4l2.h

#ifndef V4L2_CAP_SDR_CAPTURE
#define V4L2_CAP_SDR_CAPTURE	0x00100000	///< The device supports the SDR Capture interface.
#endif

#ifndef V4L2_CAP_EXT_PIX_FORMAT
#define V4L2_CAP_EXT_PIX_FORMAT	0x00200000	///< The device supports the struct v4l2_pix_format extended fields.
#endif

#ifndef V4L2_CAP_SDR_OUTPUT
#define V4L2_CAP_SDR_OUTPUT		0x00400000	///< The device supports the SDR Output interface.
#endif

#ifndef V4L2_CAP_TOUCH
#define V4L2_CAP_TOUCH			0x10000000	///< This is a touch device.
#endif

#ifndef V4L2_PIX_FMT_PRIV_MAGIC
#define V4L2_PIX_FMT_PRIV_MAGIC 0xfeedcafe	///< Indicates whether the remaining fields of the struct v4l2_pix_format are valid.
#endif

#ifndef V4L2_COLORSPACE_DEFAULT
#define V4L2_COLORSPACE_DEFAULT 0			///< The default colorspace.
#endif

#ifndef V4L2_COLORSPACE_RAW
#define V4L2_COLORSPACE_RAW 11				///< Raw colorspace: for RAW unprocessed images.
#endif

/// @}
