#!/bin/bash
# SimpleMessageKeeper (C) 2017 Stephane Charette <stephanecharette@gmail.com>
# $Id: smk_checks.sh 2117 2017-01-18 13:18:22Z stephane $


# create the directory and initialize the file if it doesn't yet exist
if (( EUID == 0 )); then
	json="/opt/ccr/smk.json"
	mkdir -p $(dirname ${json})
	if [ ! -e ${json} ]; then
		smk reset
	fi
	chmod a+rw ${json}
fi


if [ $(cut -f1 -d. /proc/uptime) -lt 60 ]; then
	smk unique 2 "Device has rebooted."
else
	# check the 1-minute, 5-minute, and 10-minute load averages
	for load_average in $(cat /proc/loadavg | tr -d '.' | cut -f1-3 -d' '); do

		# remove any leading zeros so the number isn't interpreted as octal
		load_average=$(expr $load_average + 0)

		if [ ${load_average} -gt 90 ]; then
			smk add 1 "Load average is high."
			break
		fi
	done
fi


avail_blocks=$(stat --file-system --format="%a" /)
total_blocks=$(stat --file-system --format="%b" /)
percentage=$(( avail_blocks * 100 / total_blocks ))
if [ ${percentage} -lt 20 ]; then
	smk add 1 "Running out of disk space."
else
	smk del "Running out of disk space"
fi


avail_inodes=$(stat --file-system --format="%d" /)
total_inodes=$(stat --file-system --format="%c" /)
percentage=$(( avail_inodes * 100 / total_inodes ))
if [ ${percentage} -lt 20 ]; then
	smk add 1 "Running out of inodes."
else
	smk del "Running out of inodes"
fi


# check the amount of memory
mem_total=$(cat /proc/meminfo | grep "MemTotal"     | tr -d ' kB' | cut -f2 -d':')
mem_avail=$(cat /proc/meminfo | grep "MemAvailable" | tr -d ' kB' | cut -f2 -d':')
percentage=$(( mem_avail * 100 / mem_total ))
if [ ${percentage} -lt 20 ]; then
	smk add 1 "Running out of memory."
fi

smk show

exit 0
