// GMMM (C) 2020 Stephane Charette <stephanecharette@gmail.com>
// $Id: MCFile.cpp 3087 2020-11-15 19:56:31Z stephane $


#include "MCFile.hpp"
#include <sstream>


MCFile::~MCFile()
{
	return;
}


MCFile::MCFile() :
	kiln(0),
	run(0),
	pkg(0)
{
	return;
}


MCFile::MCFile(const std::filesystem::path & path) :
	MCFile()
{
	init(path);

	return;
}


MCFile::MCFile(const size_t k, const size_t r, const size_t p) :
	kiln(k),
	run(r),
	pkg(p)
{
	std::stringstream ss;
	ss	<< k
		<< "_"
		<< std::setfill('0') << std::setw(3) << r
		<< std::setfill('0') << std::setw(3) << p
		<< ".mc";

	file = ss.str();

	return;
}


MCFile & MCFile::init(const std::filesystem::path & path)
{
	file = path;
	kiln = 0;
	run = 0;
	pkg = 0;

	/* The .mc filenames are:
	 * 
	 *		K_RRRPPP.mc
	 *
	 * where:
	 *
	 *		K is the 1-digit kiln number
	 *		RRR is the 3-digit run number
	 *		PPP is the 3-digit package number (or "000" for summary files)
	 */

	const std::regex rx(
		"(\\d)"		// 1-digit kiln
		"_"
		"(\\d{3})"	// 3-digit run
		"(\\d{3})"	// 3-digit package
		"\\.mc"
		);

	std::smatch what;
	const std::string filename = file.filename().string();

	if (std::regex_match(filename, what, rx))
	{
		kiln	= std::stoi(what[1].str());
		run		= std::stoi(what[2].str());
		pkg		= std::stoi(what[3].str());
	}
	else
	{
		throw std::invalid_argument(file.filename().string() + " is not a valid .mc file");
	}

	return *this;
}


bool MCFile::is_summary() const
{
	return pkg == 0;
}


std::string MCFile::to_string() const
{
	std::stringstream ss;
	ss << "kiln=" << kiln << ", run=" << run << ", pkg=" << pkg;

	return ss.str();
}


MCFile MCFile::get_summary_file() const
{
	return MCFile(kiln, run);
}


bool MCFile::operator<(const MCFile & rhs) const
{
	// The filenames are in the format of K_RRRPPP.mc,
	// and we want to compare the kiln, run, and pkg for operator<(),
	// so we may as well just compare the filenames.

	return file.filename() < rhs.file.filename();
}
