// GMMM (C) 2020 Stephane Charette <stephanecharette@gmail.com>
// $Id: MCFile.hpp 3087 2020-11-15 19:56:31Z stephane $


#include <set>
#include <filesystem>
#include <iostream>
#include <regex>


class MCFile final
{
	public:

		size_t kiln;
		size_t run;
		size_t pkg;

		std::filesystem::path file;

		~MCFile();

		MCFile();
		
		MCFile(const std::filesystem::path & path);

		MCFile(const size_t k, const size_t r, const size_t p=0);

		MCFile & init(const std::filesystem::path & path);

		bool is_summary() const;

		std::string to_string() const;

		MCFile get_summary_file() const;

		/// Needed to insert objects of this class into sets.
		bool operator<(const MCFile & rhs) const;
};

typedef std::set<MCFile> SetMCFiles;
