@echo off

if not exist CMakeLists.txt (
	echo "This script should be run from the root source directory, but failed to find CMake file."
	exit /b 1
	)


rd /q /s build

md build
cd build

rem set TYPE=Debug
set TYPE=Release
set ARCHITECTURE=x64

cmake -A %ARCHITECTURE% -DCMAKE_BUILD_TYPE=%TYPE% ..
if %ERRORLEVEL% NEQ 0 (
	echo "Failed to finish running CMAKE."
	exit /b 2
	)

msbuild.exe /property:Platform=%ARCHITECTURE%;Configuration=%TYPE% /target:Clean,Build -maxCpuCount -verbosity:normal -detailedSummary GormanMoistureMeterMerge.sln
if %ERRORLEVEL% NEQ 0 (
	echo "Failed to build the VisualStudio solution."
	exit /b 3
	)

echo "Done!"
