/* GPC (C) 2017-2018 Stephane Charette <stephanecharette@gmail.com>
 * $Id: GPC.hpp 2492 2018-03-21 06:22:15Z stephane $
 */

#pragma once

#include "GPCExternals.hpp"

class SessionWnd;
class SessionRecord;

/** Map of UUID (as a text string) to SessionRecord.  This tracks all of the
 * known print job session records.
 */
typedef std::map<std::string, SessionRecord> MSessions;

/** Map of UUID (as a text string) to open session window pointers.  This is
 * used to track all of the open session windows.
 */
typedef std::map<std::string, SessionWnd*> MUuidSessionWnd;


#include "GPCVersion.hpp"
#include "Cfg.hpp"
#include "LoadWnd.hpp"
#include "Misc.hpp"
#include "Log.hpp"
#include "IJS.hpp"
#include "IJB.hpp"
#include "PrintJob.hpp"
#include "SessionRecord.hpp"
#include "FieldEditor.hpp"
#include "SessionComponentLoader.hpp"
#include "SessionComponentTransfer.hpp"
#include "SessionComponent.hpp"
#include "SessionWnd.hpp"
#include "SummaryComponent.hpp"
#include "SummaryWnd.hpp"
#include "src-img.hpp"
#include "IncJet.hpp"
#include "BinaryProtocol.hpp"
#include "BinaryProtocolConnection.hpp"
#include "GPCLookAndFeel.hpp"
#include "GPCApp.hpp"
