/* GPC (C) 2017-2018 Stephane Charette <stephanecharette@gmail.com>
 * $Id: LoadWnd.hpp 2482 2018-03-13 22:24:43Z stephane $
 */

#pragma once

#include "GPC.hpp"


class LoadWnd final : public ThreadWithProgressWindow
{
	public:

		bool finished_loading;
		double total_number_of_items_to_load;
		double progress_level;

		LoadWnd(void);
		virtual ~LoadWnd(void);

		virtual void update_progress_bar(const double progress = 1.0, const std::string msg="");

		/// Return a simple text string, such as "Loading...", but randomly put a twist on it.
		virtual std::string get_status_message(void);

		/// Inherited from ThreadWithProgressWindow.
		virtual void run( void );

		/// See if there is a new version of the software available.
		virtual void check_for_new_version(void);

		/// See if there is a MOTD to display to the user.
		virtual void check_for_motd(void);

		/// See if this version of the client seems to be out-of-date.
		virtual void check_build_timestamp(void);

		/// Find the right startup directory with all the files.
		virtual void directory_handling(void);

		/// Check to see if the .json configuration file exists.
		virtual void check_for_json(void);

		void delete_old_sessions(void);
};
