/* GPC (C) 2017-2018 Stephane Charette <stephanecharette@gmail.com>
 * $Id: IncJet.hpp 2434 2018-01-09 08:13:16Z stephane $
 */

#pragma once

#include "GPC.hpp"


class IncJet final
{
	public:

		enum class EPredefinedUrl
		{
			kInvalid			= 0,
			kFirmwareVersion	= 1,	///< http://10.1.1.22/fwversion.htm
			kSystemStateUpdate	= 2,	///< http://10.1.1.22/systemstateupdate.htm (0 means idle, >0 means print)
		};

		/// Constructor.
		IncJet(void);

		/// Destructor.
		~IncJet(void);

		std::string get(const std::string &partialUrl);

		std::string get(const EPredefinedUrl &url);

		/// IP address (as a text string) of the IncJet device.  E.g., "10.1.1.22".
		std::string ip_address;
};
