/* GPC (C) 2017-2018 Stephane Charette <stephanecharette@gmail.com>
 * $Id: GPCLookAndFeel.hpp 2434 2018-01-09 08:13:16Z stephane $
 */

#pragma once

#include "GPC.hpp"


/// Customized JUCE look-and-feel.
class GPCLookAndFeel final : public LookAndFeel_V4
{
	public:

		/// Constructor.
		GPCLookAndFeel( LookAndFeel_V4::ColourScheme colour_scheme );

		/// Destructor.
		virtual ~GPCLookAndFeel( void );

		/// Inherited from LookAndFeel to use a lighter background colour.
		virtual void drawCallOutBoxBackground( CallOutBox &box, Graphics &g, const Path &path, Image &cachedImage );
};


GPCLookAndFeel *init_gpc_look_and_feel(void);

void reset_gpc_look_and_feel(void);
