/* GPC (C) 2017-2018 Stephane Charette <stephanecharette@gmail.com>
 * $Id: Misc.hpp 2481 2018-03-13 20:53:59Z stephane $
 */

#pragma once

#include "GPC.hpp"


std::string descriptive_username(void);

std::string get_url(const std::string &url);

std::string create_new_session(std::string uuid = "");

/** Flip the given image horizontally, as if we're looking in a mirror.
 * @warning This modifies the original image, so make a copy if necessary.
 */
Image &flip_horizontal(Image &img);


/** Rotate the given image 90 degrees counter-clockwise.
 * @warning This modifies the original image, so make a copy if necessary.
 * @warning There is a single character difference between the function that
 * handles clockwise and counter-clockwise!
 * @see @ref rotate_cw90()
 */
Image &rotate_ccw90(Image &img);


/** Rotate the given image 90 degrees clockwise.
 * @warning This modifies the original image, so make a copy if necessary.
 * @warning There is a single character difference between the function that
 * handles clockwise and counter-clockwise!
 * @see @ref rotate_ccw90()
 */
Image &rotate_cw90(Image &img);

/// Rotate the image 180 degrees.
Image &rotate_180(Image &img);

/// Create an exclusive lock file with a name similar to the one that was passed in.
void lock_file(const File &file);


/// Unlock all files obtained via previous calls to @ref lock_file().
void unlock_all_files(void);

/// Create a monochrome .bmp file from the given image.
void save_image_as_bmp(const Image &img, const File &file);

/// Load a .bmp image.
Image load_image_from_bmp(const File &file);
