/* GPC (C) 2017-2018 Stephane Charette <stephanecharette@gmail.com>
 * $Id: PrintJob.hpp 2474 2018-03-11 01:42:57Z stephane $
 */

#pragma once

#include "GPC.hpp"


class PrintJob final
{
	public:

		/// Empty constructor.  Use @ref load() to specify the .ijs file.
		PrintJob(void);

		/// Destructor.
		~PrintJob(void);

		/** Load the given .ijs file and every image.  The specified .ijs file
		 * @b must exist.  Internally, this calls @ref load_isj() and then
		 * @ref load_ijb() for every bitmap.
		 */
		PrintJob &load(File file);

		/// Load just the .ijs file, and skip loading the .ijb files for later.
		PrintJob &load_ijs(File file);

		/// Load the .ijb file corresponding to the given index.
		PrintJob &load_ijb(const size_t idx);

		/** Copy all of the necessary files (.ijs and .ijb) to a new directory.
		 * By the time this returns, the root directory will have been updated
		 * to reflect this change.
		 */
		PrintJob &copy_to_new_directory(File new_dir);

		/// The root (base) directory for the entire print job.  The .ijs and .ijb files are in this directory.
		File root_directory;

		/// The underlying .ijs file.
		IJS ijs;

		/// A vector of IJB objects, in stored in the same order as the bitmaps in the ijs file.
		std::vector<IJB> ijbs;
};
